/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.render;

import java.util.List;
import org.apache.jmeter.extractor.json.jsonpath.JSONManager;
import org.apache.jmeter.extractor.json.render.AbstractRenderAsJsonRenderer;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderAsJsonRenderer
extends AbstractRenderAsJsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(RenderAsJsonRenderer.class);

    @Override
    protected String getTabLabel() {
        return JMeterUtils.getResString("jsonpath_tester_title");
    }

    @Override
    protected String getTestButtonLabel() {
        return JMeterUtils.getResString("jsonpath_tester_button_test");
    }

    @Override
    protected String getExpressionLabel() {
        return JMeterUtils.getResString("jsonpath_tester_field");
    }

    @Override
    protected String process(String textToParse) {
        String expression = this.getExpression();
        try {
            List<Object> matchStrings = this.extractWithTechnology(textToParse, expression);
            if (matchStrings.isEmpty()) {
                return "NO MATCH";
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (Object obj : matchStrings) {
                String objAsString = obj != null ? obj.toString() : "";
                builder.append("Result[").append(i++).append("]=").append(objAsString).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            log.debug("Exception extracting from '{}' with expression '{}'", (Object)textToParse, (Object)expression);
            return "Exception: " + e.getMessage();
        }
    }

    private List<Object> extractWithTechnology(String textToParse, String expression) throws Exception {
        JSONManager jsonManager = new JSONManager();
        return jsonManager.extractWithJsonPath(textToParse, expression);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString("jsonpath_renderer");
    }
}

