/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(CharFunction.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__char";
    private Object[] values;

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        StringBuilder sb = new StringBuilder(this.values.length);
        for (Object val : this.values) {
            String numberString = ((CompoundVariable)val).execute().trim();
            try {
                long value = Long.decode(numberString);
                char ch = (char)value;
                sb.append(ch);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse {} : {}", (Object)numberString, (Object)e.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkMinParameterCount(parameters, 1);
        this.values = parameters.toArray();
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString("char_value"));
    }
}

