/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.functions.FileRowColContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileWrapper {
    private static final Logger log = LoggerFactory.getLogger(FileWrapper.class);
    private static final int NO_LINE = -1;
    private static volatile String defaultFile = "";
    private static final Map<String, FileRowColContainer> fileContainers = new HashMap<String, FileRowColContainer>();
    private static final ThreadLocal<Map<String, FileWrapper>> filePacks = ThreadLocal.withInitial(HashMap::new);
    private final FileRowColContainer container;
    private int currentRow;

    private FileWrapper(FileRowColContainer fdc) {
        this.container = fdc;
        this.currentRow = -1;
    }

    private static String checkDefault(String file) {
        if (file.length() == 0) {
            if (fileContainers.size() == 1 && defaultFile.length() > 0) {
                log.warn("Using default: {}", (Object)defaultFile);
                file = defaultFile;
            } else {
                log.error("Cannot determine default file name");
            }
        }
        return file;
    }

    public static synchronized void open(String file, String alias) {
        log.info("Opening {} as {}", (Object)file, (Object)alias);
        file = FileWrapper.checkDefault(file);
        if (alias.length() == 0) {
            log.error("Alias cannot be empty");
            return;
        }
        Map<String, FileWrapper> m = filePacks.get();
        if (m.get(alias) == null) {
            try {
                FileRowColContainer frcc = FileWrapper.getFile(file, alias);
                log.info("Stored {} as {}", (Object)file, (Object)alias);
                m.put(alias, new FileWrapper(frcc));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static FileRowColContainer getFile(String file, String alias) throws FileNotFoundException, IOException {
        FileRowColContainer frcc = fileContainers.get(alias);
        if (frcc == null) {
            frcc = new FileRowColContainer(file);
            fileContainers.put(alias, frcc);
            log.info("Saved {} as {} delimiter=<{}>", file, alias, frcc.getDelimiter());
            if (defaultFile.length() == 0) {
                defaultFile = file;
            }
        }
        return frcc;
    }

    public static void endRow(String file) {
        file = FileWrapper.checkDefault(file);
        Map<String, FileWrapper> my = filePacks.get();
        FileWrapper fw = my.get(file);
        if (fw == null) {
            log.warn("endRow(): no entry for {}", (Object)file);
        } else {
            fw.endRow();
        }
    }

    private void endRow() {
        if (this.currentRow == -1) {
            log.warn("endRow() called twice in succession");
        }
        this.currentRow = -1;
    }

    public static String getColumn(String file, int col) {
        Map<String, FileWrapper> my = filePacks.get();
        FileWrapper fw = my.get(file);
        if (fw == null) {
            if (file.startsWith("*")) {
                log.warn("Cannot perform initial open using alias {}", (Object)file);
            } else {
                file = FileWrapper.checkDefault(file);
                log.info("Attaching {}", (Object)file);
                FileWrapper.open(file, file);
                fw = my.get(file);
            }
            if (fw == null) {
                return "";
            }
        }
        return fw.getColumn(col);
    }

    private String getColumn(int col) {
        if (this.currentRow == -1) {
            this.currentRow = this.container.nextRow();
        }
        return this.container.getColumn(this.currentRow, col);
    }

    public static int getCurrentRow(String file) {
        Map<String, FileWrapper> my = filePacks.get();
        FileWrapper fw = my.get(file);
        if (fw == null) {
            return -1;
        }
        return fw.currentRow;
    }

    public static void clearAll() {
        log.debug("clearAll()");
        Map<String, FileWrapper> my = filePacks.get();
        Iterator<Map.Entry<String, FileWrapper>> i = my.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, FileWrapper> fw = i.next();
            log.info("Removing {}", (Object)fw);
            i.remove();
        }
        fileContainers.clear();
        defaultFile = "";
    }
}

