/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;

public class IsPropDefined
extends AbstractFunction {
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__isPropDefined";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 1;
    private CompoundVariable[] values;

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String propertyName = this.values[0].execute();
        String propertyValue = JMeterUtils.getProperty(propertyName);
        return Boolean.toString(propertyValue != null);
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 1);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString("property_name_param"));
    }
}

