/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class IterationCounter
extends AbstractFunction
implements ThreadListener {
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__counter";
    private Object[] variables;
    private AtomicInteger globalCounter = new AtomicInteger();
    private ThreadLocal<AtomicInteger> perThreadInt = ThreadLocal.withInitial(AtomicInteger::new);

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        boolean perThread = Boolean.parseBoolean(((CompoundVariable)this.variables[0]).execute());
        String varName = "";
        if (this.variables.length >= 2) {
            varName = ((CompoundVariable)this.variables[1]).execute().trim();
        }
        String counterString = "";
        counterString = perThread ? String.valueOf(this.perThreadInt.get().addAndGet(1)) : String.valueOf(this.globalCounter.addAndGet(1));
        if (vars != null && varName.length() > 0) {
            vars.put(varName, counterString);
        }
        return counterString;
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 2);
        this.variables = parameters.toArray();
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    @Override
    public void threadStarted() {
    }

    @Override
    public void threadFinished() {
        this.perThreadInt.remove();
    }

    static {
        desc.add(JMeterUtils.getResString("iteration_counter_arg_1"));
        desc.add(JMeterUtils.getResString("function_name_paropt"));
    }
}

