/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class Property
extends AbstractFunction {
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__property";
    private static final int MIN_PARAMETER_COUNT = 1;
    private static final int MAX_PARAMETER_COUNT = 3;
    private Object[] values;

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables variables;
        String variableName;
        String propertyName;
        String propertyDefault = propertyName = ((CompoundVariable)this.values[0]).execute();
        if (this.values.length > 2) {
            propertyDefault = ((CompoundVariable)this.values[2]).execute();
        }
        String propertyValue = JMeterUtils.getPropDefault(propertyName, propertyDefault);
        if (this.values.length > 1 && (variableName = ((CompoundVariable)this.values[1]).execute()).length() > 0 && (variables = this.getVariables()) != null) {
            variables.put(variableName, propertyValue);
        }
        return propertyValue;
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray();
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString("property_name_param"));
        desc.add(JMeterUtils.getResString("function_name_paropt"));
        desc.add(JMeterUtils.getResString("property_default_param"));
    }
}

