/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomString
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(RandomString.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__RandomString";
    private CompoundVariable[] values;
    private static final int MAX_PARAM_COUNT = 3;
    private static final int MIN_PARAM_COUNT = 1;
    private static final int CHARS = 2;
    private static final int PARAM_NAME = 3;

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        int length = Integer.parseInt(this.values[0].execute());
        String charsToUse = null;
        if (this.values.length >= 2 && (charsToUse = this.values[1].execute().trim()).length() <= 0) {
            charsToUse = null;
        }
        String myName = "";
        if (this.values.length >= 3) {
            myName = this.values[2].execute().trim();
        }
        String myValue = null;
        myValue = StringUtils.isEmpty(charsToUse) ? RandomStringUtils.random(length) : RandomStringUtils.random(length, charsToUse);
        if (myName.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(myName, myValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} name:{} value:{}", Thread.currentThread().getName(), myName, myValue);
        }
        return myValue;
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 1, 3);
        this.values = parameters.toArray(new CompoundVariable[parameters.size()]);
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString("random_string_length"));
        desc.add(JMeterUtils.getResString("random_string_chars_to_use"));
        desc.add(JMeterUtils.getResString("function_name_paropt"));
    }
}

