/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(SplitFunction.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__split";
    private static final int MIN_PARAMETER_COUNT = 2;
    private static final int MAX_PARAMETER_COUNT = 3;
    private Object[] values;

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars = this.getVariables();
        String stringToSplit = ((CompoundVariable)this.values[0]).execute();
        String varNamePrefix = ((CompoundVariable)this.values[1]).execute().trim();
        String splitString = ",";
        if (this.values.length > 2) {
            String newSplitString = ((CompoundVariable)this.values[2]).execute();
            splitString = newSplitString.length() > 0 ? newSplitString : splitString;
        }
        log.debug("Split {} using {} into {}", stringToSplit, splitString, varNamePrefix);
        String[] parts = JOrphanUtils.split(stringToSplit, splitString, "?");
        vars.put(varNamePrefix, stringToSplit);
        vars.put(varNamePrefix + "_n", Integer.toString(parts.length));
        for (int i = 1; i <= parts.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug(parts[i - 1]);
            }
            vars.put(varNamePrefix + "_" + i, parts[i - 1]);
        }
        vars.remove(varNamePrefix + "_" + (parts.length + 1));
        return stringToSplit;
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 3);
        this.values = parameters.toArray();
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString("split_function_string"));
        desc.add(JMeterUtils.getResString("function_name_param"));
        desc.add(JMeterUtils.getResString("split_function_separator"));
    }
}

