/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToFile
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(StringToFile.class);
    private static final List<String> desc = new ArrayList<String>();
    private static final String KEY = "__StringToFile";
    private static final ConcurrentHashMap<String, Lock> lockMap = new ConcurrentHashMap();
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\\\\n");
    private Object[] values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToFile() throws IOException {
        block7: {
            String charsetParamValue;
            String appendString;
            String fileName = ((CompoundVariable)this.values[0]).execute().trim();
            String content = ((CompoundVariable)this.values[1]).execute();
            boolean append = true;
            if (this.values.length >= 3 && !(appendString = ((CompoundVariable)this.values[2]).execute().toLowerCase().trim()).isEmpty()) {
                append = Boolean.parseBoolean(appendString);
            }
            content = NEW_LINE_PATTERN.matcher(content).replaceAll(System.lineSeparator());
            Charset charset = StandardCharsets.UTF_8;
            if (this.values.length == 4 && StringUtils.isNotEmpty(charsetParamValue = ((CompoundVariable)this.values[3]).execute())) {
                charset = Charset.forName(charsetParamValue);
            }
            if (fileName.isEmpty()) {
                log.error("File name '{}' is empty", (Object)fileName);
                return false;
            }
            log.debug("Writing {} to file {} with charset {} and append {}", content, fileName, charset, append);
            Lock lock = lockMap.computeIfAbsent(fileName, key -> new ReentrantLock());
            lock.lock();
            try {
                File file = new File(fileName);
                File fileParent = file.getParentFile();
                if (fileParent == null || fileParent.exists() && fileParent.isDirectory() && fileParent.canWrite()) {
                    FileUtils.writeStringToFile(file, content, charset, append);
                    break block7;
                }
                log.error("The parent file of {} doesn't exist or is not writable", (Object)file);
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return true;
    }

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        boolean executionResult;
        try {
            executionResult = this.writeToFile();
        }
        catch (UnsupportedCharsetException ue) {
            executionResult = false;
            log.error("The encoding of file is not supported", ue);
        }
        catch (IllegalCharsetNameException ie) {
            executionResult = false;
            log.error("The encoding of file contains illegal characters", ie);
        }
        catch (IOException e) {
            executionResult = false;
            log.error("IOException occurred", e);
        }
        return String.valueOf(executionResult);
    }

    @Override
    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 4);
        this.values = parameters.toArray();
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString("string_to_file_pathname"));
        desc.add(JMeterUtils.getResString("string_to_file_content"));
        desc.add(JMeterUtils.getResString("string_to_file_way_to_write"));
        desc.add(JMeterUtils.getResString("string_to_file_encoding"));
    }
}

