/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.functions.AbstractFunctionByKey;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;

public class ThreadGroupName
extends AbstractFunctionByKey {
    private static final String KEY = "__threadGroupName";
    private static final List<String> DESC = new ArrayList<String>();

    public ThreadGroupName() {
        super(KEY, 0);
    }

    @Override
    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterContext context = currentSampler != null ? currentSampler.getThreadContext() : JMeterContextService.getContext();
        AbstractThreadGroup threadGroup = context.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup.getName();
        }
        return "";
    }

    @Override
    public List<String> getArgumentDesc() {
        return DESC;
    }
}

