/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.functions.XPathWrapper;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPath
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(XPath.class);
    private static final String KEY = "__XPath";
    private static final List<String> desc = new ArrayList<String>();
    private Object[] values;

    @Override
    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String fileName = ((CompoundVariable)this.values[0]).execute();
        String xpathString = ((CompoundVariable)this.values[1]).execute();
        log.debug("execute ({} {})", (Object)fileName, (Object)xpathString);
        String myValue = XPathWrapper.getXPathString(fileName, xpathString);
        log.debug("execute value: {}", (Object)myValue);
        return myValue;
    }

    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }

    @Override
    public String getReferenceKey() {
        return KEY;
    }

    @Override
    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        if (log.isDebugEnabled()) {
            log.debug("setParameter - Collection.size={}", (Object)Integer.toString(parameters.size()));
        }
        this.values = parameters.toArray();
        if (log.isDebugEnabled()) {
            for (int i = 0; i < parameters.size(); ++i) {
                log.debug("i:{}", (Object)((CompoundVariable)this.values[i]).execute());
            }
        }
        this.checkParameterCount(parameters, 2);
        XPathWrapper.clearAll();
    }

    static {
        desc.add(JMeterUtils.getResString("xpath_file_file_name"));
        desc.add(JMeterUtils.getResString("xpath_expression"));
    }
}

