/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.logging.GuiLogEventListener;
import org.apache.jmeter.gui.logging.LogEventObject;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.util.JMeterUtils;

public class LoggerPanel
extends JPanel
implements GuiLogEventListener {
    private static final long serialVersionUID = 4935188629475943229L;
    private final JTextArea textArea;
    private static final int LOGGER_PANEL_MAX_LINES = JMeterUtils.getPropDefault("jmeter.loggerpanel.maxlength", 1000);
    private static final boolean LOGGER_PANEL_RECEIVE_WHEN_CLOSED = JMeterUtils.getPropDefault("jmeter.loggerpanel.enable_when_closed", true);
    private static final int LOGGER_PANEL_REFRESH_PERIOD = JMeterUtils.getPropDefault("jmeter.gui.refresh_period", 500);
    private final Queue<String> events = LOGGER_PANEL_MAX_LINES > 0 ? new CircularFifoQueue<String>(LOGGER_PANEL_MAX_LINES) : new ArrayDeque<String>();
    private volatile boolean logChanged = false;

    public LoggerPanel() {
        this.textArea = this.init();
    }

    private JTextArea init() {
        Object jTextArea;
        Object areaScrollPane;
        this.setLayout(new BorderLayout());
        if (JMeterUtils.getPropDefault("loggerpanel.usejsyntaxtext", true)) {
            JSyntaxTextArea jSyntaxTextArea = JSyntaxTextArea.getInstance(15, 80, true);
            jSyntaxTextArea.setSyntaxEditingStyle("text/plain");
            jSyntaxTextArea.setCodeFoldingEnabled(false);
            jSyntaxTextArea.setAntiAliasingEnabled(false);
            jSyntaxTextArea.setEditable(false);
            jSyntaxTextArea.setLineWrap(false);
            jSyntaxTextArea.setLanguage("text");
            jSyntaxTextArea.setMargin(new Insets(2, 2, 2, 2));
            areaScrollPane = JTextScrollPane.getInstance(jSyntaxTextArea);
            jTextArea = jSyntaxTextArea;
        } else {
            jTextArea = new JTextArea(15, 80);
            areaScrollPane = new JScrollPane((Component)jTextArea);
        }
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)areaScrollPane, "Center");
        this.initWorker();
        return jTextArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLogEvent(LogEventObject logEventObject) {
        if (!LOGGER_PANEL_RECEIVE_WHEN_CLOSED && !GuiPackage.getInstance().getMenuItemLoggerPanel().getModel().isSelected()) {
            return;
        }
        String logMessage = logEventObject.toString();
        Queue<String> queue = this.events;
        synchronized (queue) {
            this.events.add(logMessage);
        }
        this.logChanged = true;
    }

    private void initWorker() {
        Timer timer = new Timer(LOGGER_PANEL_REFRESH_PERIOD, e -> this.updateLogEntries());
        timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLogEntries() {
        if (!this.logChanged) {
            return;
        }
        this.logChanged = false;
        StringBuilder builder = new StringBuilder();
        Queue<String> queue = this.events;
        synchronized (queue) {
            for (String line : this.events) {
                builder.append(line);
            }
        }
        String logText = builder.toString();
        JTextArea jTextArea = this.textArea;
        synchronized (jTextArea) {
            if (LOGGER_PANEL_MAX_LINES > 0) {
                this.textArea.setText(logText);
            } else {
                this.textArea.append(logText);
            }
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Queue<String> queue = this.events;
        synchronized (queue) {
            this.events.clear();
        }
        this.logChanged = true;
    }
}

