/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.Functor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavePropertyDialog
extends JDialog
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(SavePropertyDialog.class);
    private static final long serialVersionUID = 233L;
    private static final Map<String, Functor> functors = new HashMap<String, Functor>();
    private static final String RESOURCE_PREFIX = "save_";
    private SampleSaveConfiguration saveConfig;

    @Deprecated
    public SavePropertyDialog() {
        log.warn("Constructor only intended for use in testing");
    }

    public SavePropertyDialog(Frame owner, String title, boolean modal, SampleSaveConfiguration s) {
        super(owner, title, modal);
        this.saveConfig = s;
        log.debug("SampleSaveConfiguration = {}", (Object)this.saveConfig);
        this.initDialog();
    }

    private void initDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        int configCount = SampleSaveConfiguration.SAVE_CONFIG_NAMES.size() / 3 + 1;
        log.debug("grid panel is {} by {}", (Object)3, (Object)configCount);
        JPanel checkPanel = new JPanel(new GridLayout(configCount, 3));
        for (String name : SampleSaveConfiguration.SAVE_CONFIG_NAMES) {
            try {
                JCheckBox check = new JCheckBox(JMeterUtils.getResString(RESOURCE_PREFIX + name), this.getSaveState(SampleSaveConfiguration.getterName(name)));
                check.addActionListener(this);
                String actionCommand = SampleSaveConfiguration.setterName(name);
                check.setActionCommand(actionCommand);
                if (!functors.containsKey(actionCommand)) {
                    functors.put(actionCommand, new Functor(actionCommand));
                }
                checkPanel.add((Component)check, "North");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                log.warn("Problem creating save config dialog", e2);
            }
        }
        this.getContentPane().add((Component)checkPanel, "North");
        JButton exit = new JButton(JMeterUtils.getResString("done"));
        this.getContentPane().add((Component)exit, "South");
        exit.addActionListener(e -> this.dispose());
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = 2208129319916921772L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePropertyDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        rootPane.getActionMap().put(escapeAction.getValue("Name"), escapeAction);
        return rootPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        Functor f = functors.get(action);
        f.invoke(this.saveConfig, new Object[]{((JCheckBox)e.getSource()).isSelected()});
    }

    private boolean getSaveState(String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = SampleSaveConfiguration.class.getMethod(methodName, new Class[0]);
        return (Boolean)method.invoke((Object)this.saveConfig, new Object[0]);
    }

    public SampleSaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    public void setSaveConfig(SampleSaveConfiguration saveConfig) {
        this.saveConfig = saveConfig;
    }
}

