/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.jmeter.gui.GlobalUndoableEdit;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.SimpleCompoundEdit;
import org.apache.jmeter.gui.TreeState;
import org.apache.jmeter.gui.UndoHistoryItem;
import org.apache.jmeter.gui.action.UndoCommand;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoHistory
implements TreeModelListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UndoHistory.class);
    private static final int HISTORY_SIZE = JMeterUtils.getPropDefault("undo.history.size", 0);
    private boolean working = false;
    private List<HistoryListener> listeners = new ArrayList<HistoryListener>();
    private final UndoManager manager = new UndoManager();
    private final Deque<SimpleCompoundEdit> transactions = new ArrayDeque<SimpleCompoundEdit>();
    private UndoHistoryItem lastKnownState = null;

    public UndoHistory() {
        this.manager.setLimit(HISTORY_SIZE);
    }

    public void clear() {
        if (this.working) {
            return;
        }
        log.debug("Clearing undo history");
        this.manager.discardAllEdits();
        if (this.isTransaction()) {
            if (log.isWarnEnabled()) {
                log.warn("Clearing undo history with {} unfinished transactions", (Object)this.transactions.size());
            }
            this.transactions.clear();
        }
        this.lastKnownState = null;
        this.notifyListeners();
    }

    public void add(JMeterTreeModel treeModel, String comment) {
        if (!UndoHistory.isEnabled()) {
            log.debug("undo.history.size is set to 0, undo/redo feature is disabled");
            return;
        }
        if (this.working) {
            log.debug("Not adding history because of noop");
            return;
        }
        JMeterTreeNode root = (JMeterTreeNode)treeModel.getRoot();
        if (root.getChildCount() < 1) {
            log.debug("Not adding history because of no children");
            return;
        }
        String name = root.getName();
        log.debug("Adding history element {}: {}", (Object)name, (Object)comment);
        this.working = true;
        HashTree tree = treeModel.getCurrentSubTree((JMeterTreeNode)treeModel.getRoot());
        tree = (HashTree)tree.getTree(tree.getArray()[0]).clone();
        HashTree copy = UndoCommand.convertAndCloneSubTree(tree);
        GuiPackage guiPackage = GuiPackage.getInstance();
        boolean dirty = guiPackage != null ? guiPackage.isDirty() : false;
        this.addEdit(new UndoHistoryItem(copy, comment, TreeState.from(guiPackage), dirty));
        this.working = false;
    }

    public void undo() {
        if (!this.canUndo()) {
            log.warn("Can't undo, we're already on the last record");
            return;
        }
        this.manager.undo();
    }

    public void redo() {
        if (!this.canRedo()) {
            log.warn("Can't redo, we're already on the first record");
            return;
        }
        this.manager.redo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(UndoHistoryItem z) {
        GuiPackage guiInstance = GuiPackage.getInstance();
        JMeterTreeModel acceptorModel = guiInstance.getTreeModel();
        try {
            this.loadHistoricalTree(acceptorModel, guiInstance, z.getTree());
        }
        finally {
            z.getTreeState().restore(guiInstance);
            guiInstance.setDirty(z.isDirty());
        }
        this.setLastKnownState(z);
        guiInstance.updateCurrentGui();
        guiInstance.getMainFrame().repaint();
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHistoricalTree(JMeterTreeModel acceptorModel, GuiPackage guiInstance, HashTree newModel) {
        acceptorModel.removeTreeModelListener(this);
        this.working = true;
        try {
            guiInstance.getTreeModel().clearTestPlan();
            guiInstance.addSubTree(newModel);
        }
        catch (Exception ex) {
            log.error("Failed to load from history", ex);
        }
        finally {
            acceptorModel.addTreeModelListener(this);
            this.working = false;
        }
    }

    public boolean canRedo() {
        return this.manager.canRedo();
    }

    public boolean canUndo() {
        return this.manager.canUndo();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent tme) {
        String name = ((JMeterTreeNode)tme.getTreePath().getLastPathComponent()).getName();
        log.debug("Nodes changed {}", (Object)name);
        JMeterTreeModel sender = (JMeterTreeModel)tme.getSource();
        this.add(sender, "Node changed " + name);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent tme) {
        String name = ((JMeterTreeNode)tme.getTreePath().getLastPathComponent()).getName();
        log.debug("Nodes inserted {}", (Object)name);
        JMeterTreeModel sender = (JMeterTreeModel)tme.getSource();
        this.add(sender, "Add " + name);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent tme) {
        String name = ((JMeterTreeNode)tme.getTreePath().getLastPathComponent()).getName();
        log.debug("Nodes removed: {}", (Object)name);
        this.add((JMeterTreeModel)tme.getSource(), "Remove " + name);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent tme) {
        log.debug("Nodes struct changed");
        this.add((JMeterTreeModel)tme.getSource(), "Complex Change");
    }

    public static boolean isEnabled() {
        return HISTORY_SIZE > 0;
    }

    public void registerHistoryListener(HistoryListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (HistoryListener listener : this.listeners) {
            listener.notifyChangeInHistory(this);
        }
    }

    private void addEdit(UndoHistoryItem item) {
        if (this.lastKnownState != null) {
            GlobalUndoableEdit edit = new GlobalUndoableEdit(item, this.lastKnownState, this::reload);
            this.addEdit(edit);
        } else {
            log.debug("Skipping undo since there is no previous known state");
        }
        this.lastKnownState = item;
    }

    private void addEdit(UndoableEdit edit) {
        if (this.isTransaction()) {
            this.transactions.peek().addEdit(edit);
        } else {
            this.manager.addEdit(edit);
            this.notifyListeners();
        }
    }

    void endUndoTransaction() {
        if (!UndoHistory.isEnabled()) {
            return;
        }
        if (!this.isTransaction()) {
            log.error("Undo transaction ended without beginning", new Exception());
            return;
        }
        SimpleCompoundEdit edit = this.transactions.pop();
        edit.end();
        if (!edit.isEmpty()) {
            this.addEdit(edit);
        }
    }

    void beginUndoTransaction() {
        if (UndoHistory.isEnabled()) {
            this.transactions.add(new SimpleCompoundEdit());
        }
    }

    boolean isTransaction() {
        return !this.transactions.isEmpty();
    }

    private void setLastKnownState(UndoHistoryItem previous) {
        this.lastKnownState = previous;
    }

    public static interface HistoryListener {
        public void notifyChangeInHistory(UndoHistory var1);
    }
}

