/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.sampler.DebugSampler;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.gui.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTransactionAndSamplerNames
extends AbstractAction
implements MenuCreator {
    private static final Logger log = LoggerFactory.getLogger(ExportTransactionAndSamplerNames.class);
    private static final String TRANSACTIONS_REGEX_PATTERN = JMeterUtils.getPropDefault("jmeter.reportgenerator.exported_transactions_pattern", "[a-zA-Z0-9_ \\-{}\\$\\.]*[-][0-9]*");
    private static final Pattern TRANSACTIONS_REGEX = Pattern.compile(TRANSACTIONS_REGEX_PATTERN);
    private static final Set<String> commands = new HashSet<String>();
    private static final String EXPORT_NAMES = "export_transactions_names_action";

    @Override
    public void doAction(ActionEvent e) {
        HashTree wholeTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
        SamplerAndTransactionNameVisitor visitor = new SamplerAndTransactionNameVisitor();
        wholeTree.traverse(visitor);
        Set<String> sampleNames = visitor.getListOfTransactions();
        if (sampleNames.isEmpty()) {
            log.warn("No transaction exported using regexp '{}', modify property '{}' to fix this problem", (Object)TRANSACTIONS_REGEX_PATTERN, (Object)"report_transactions_pattern");
            this.showResult(e, "No transaction exported using regexp '" + TRANSACTIONS_REGEX_PATTERN + "', modify property 'report_transactions_pattern' to fix this problem");
        } else {
            StringBuilder builder = new StringBuilder();
            for (String sampleName : sampleNames) {
                builder.append(sampleName).append('|');
            }
            builder.setLength(builder.length() - 1);
            String result = builder.toString();
            log.info("Exported transactions: jmeter.reportgenerator.exporter.html.series_filter=^({})(-success|-failure)?$", (Object)result);
            this.showResult(e, "jmeter.reportgenerator.exporter.html.series_filter=^(" + result + ")(-success|-failure)?$");
        }
    }

    private final void showResult(ActionEvent event, String result) {
        EscapeDialog messageDialog = new EscapeDialog(this.getParentFrame(event), JMeterUtils.getResString("export_transactions_title"), false);
        Container contentPane = messageDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JLabel(JMeterUtils.getResString("export_transactions_exported_property"), 0), "North");
        JSyntaxTextArea syntaxTextArea = JSyntaxTextArea.getInstance(10, 80, true);
        syntaxTextArea.setText(result);
        syntaxTextArea.setCaretPosition(0);
        contentPane.add((Component)((Object)JTextScrollPane.getInstance(syntaxTextArea)), "Center");
        messageDialog.pack();
        ComponentUtil.centerComponentInComponent(GuiPackage.getInstance().getMainFrame(), messageDialog);
        SwingUtilities.invokeLater(() -> messageDialog.setVisible(true));
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.TOOLS) {
            JMenuItem menuItemIC = new JMenuItem(JMeterUtils.getResString(EXPORT_NAMES), 0);
            menuItemIC.setName(EXPORT_NAMES);
            menuItemIC.setActionCommand(EXPORT_NAMES);
            menuItemIC.setAccelerator(null);
            menuItemIC.addActionListener(ActionRouter.getInstance());
            return new JMenuItem[]{menuItemIC};
        }
        return new JMenuItem[0];
    }

    @Override
    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    @Override
    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    @Override
    public void localeChanged() {
    }

    static {
        commands.add(EXPORT_NAMES);
    }

    private static class SamplerAndTransactionNameVisitor
    implements HashTreeTraverser {
        private Set<String> listOfTransactions = new TreeSet<String>();

        @Override
        public void addNode(Object object, HashTree subTree) {
            Matcher matcher;
            JMeterTreeNode treeNode = (JMeterTreeNode)object;
            Object userObject = treeNode.getUserObject();
            if ((userObject instanceof TransactionController || userObject instanceof Sampler && !(userObject instanceof TestAction) && !(userObject instanceof DebugSampler)) && !(matcher = TRANSACTIONS_REGEX.matcher(((TestElement)userObject).getName())).matches()) {
                this.listOfTransactions.add(((TestElement)userObject).getName());
            }
        }

        @Override
        public void subtractNode() {
        }

        @Override
        public void processPath() {
        }

        public Set<String> getListOfTransactions() {
            return this.listOfTransactions;
        }
    }
}

