/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.swing.HtmlPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Help
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(Help.class);
    private static final boolean USE_LOCAL_HELP = JMeterUtils.getPropDefault("help.local", false);
    private static final Set<String> commands = new HashSet<String>();
    private static final String HELP_DOCS = "file:///" + JMeterUtils.getJMeterHome() + "/printable_docs/usermanual/";
    private static final String HELP_COMPONENTS = HELP_DOCS + "component_reference.html";
    public static final String HELP_FUNCTIONS = HELP_DOCS + "functions.html";
    private static JDialog helpWindow;
    private static final HtmlPane helpDoc;
    private static final JScrollPane scroller;

    @Override
    public void doAction(ActionEvent e) {
        if (USE_LOCAL_HELP) {
            JDialog dialog = Help.initHelpWindow();
            dialog.setVisible(true);
            StringBuilder url = new StringBuilder();
            if (e.getSource() instanceof String[]) {
                String[] source = (String[])e.getSource();
                url.append(source[0]).append('#').append(source[1]);
            } else {
                url.append(HELP_COMPONENTS).append('#').append(GuiPackage.getInstance().getTreeListener().getCurrentNode().getDocAnchor());
            }
            try {
                helpDoc.setPage(url.toString());
            }
            catch (IOException ioe) {
                log.error("Error setting page for url, {}", (Object)url, (Object)ioe);
                helpDoc.setText("<html><head><title>Problem loading help page</title><style><!--.note { background-color: #ffeeee; border: 1px solid brown; }div { padding: 10; margin: 10; }--></style></head><body><div class='note'><h1>Problem loading help page</h1><div>Can't load url: &quot;<em>" + url.toString() + "</em>&quot;</div><div>See log for more info</div></body>");
            }
        } else if (e.getSource() instanceof String[]) {
            ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "link_function_reference:"));
        } else {
            String[] source = new String[]{"link_component_reference:", GuiPackage.getInstance().getTreeListener().getCurrentNode().getDocAnchor()};
            ActionRouter.getInstance().doActionNow(new ActionEvent(source, e.getID(), "link_component_reference:"));
        }
    }

    private static JDialog initHelpWindow() {
        if (helpWindow == null) {
            helpWindow = new EscapeDialog(new Frame(), JMeterUtils.getResString("help"), false);
            helpWindow.getContentPane().setLayout(new GridLayout(1, 1));
            helpWindow.getContentPane().removeAll();
            helpWindow.getContentPane().add(scroller);
            ComponentUtil.centerComponentInWindow(helpWindow, 60);
        }
        return helpWindow;
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("help");
        helpDoc = new HtmlPane();
        scroller = new JScrollPane(helpDoc);
        helpDoc.setEditable(false);
    }
}

