/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.Theme;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;

public class LookAndFeelCommand
extends AbstractAction {
    private static final String JMETER_LAF = "jmeter.laf";
    private static final Map<String, MenuItem> items = new LinkedHashMap<String, MenuItem>();
    private static final Preferences PREFS = Preferences.userNodeForPackage(LookAndFeelCommand.class);
    private static final String USER_PREFS_KEY = "laf.command";

    public static Collection<MenuItem> getMenuItems() {
        return Collections.unmodifiableCollection(items.values());
    }

    @Deprecated
    public static String getJMeterLaf() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        laf = JMeterUtils.getProperty("jmeter.laf." + osName.replace(' ', '_'));
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String[] osFamily = osName.split("\\s");
        laf = JMeterUtils.getProperty("jmeter.laf." + osFamily[0]);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        laf = JMeterUtils.getPropDefault(JMETER_LAF, "com.bulenkov.darcula.DarculaLaf");
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static String getPreferredLafCommand() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return laf;
        }
        String jMeterLaf = LookAndFeelCommand.getJMeterLaf();
        if (jMeterLaf.equals("com.bulenkov.darcula.DarculaLaf")) {
            return MenuItem.ofDarklafTheme((Theme)new DarculaTheme()).command;
        }
        return MenuItem.of((String)"default", (String)jMeterLaf).command;
    }

    private static String checkLafName(String laf) {
        if ("System".equalsIgnoreCase(laf)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if ("CrossPlatform".equalsIgnoreCase(laf)) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return laf;
    }

    public static boolean isDarklafTheme() {
        return "Darklaf".equals(UIManager.getLookAndFeel().getID());
    }

    public static boolean isDark() {
        return LookAndFeelCommand.isDarklafTheme() && Theme.isDark((Theme)LafManager.getTheme());
    }

    public static void activateLookAndFeel(String command) {
        GuiPackage instance;
        MenuItem item = items.get(command);
        String className = item.lafClassName;
        if (item.lafTheme != null) {
            LafManager.setTheme((Theme)item.lafTheme);
        }
        if ((instance = GuiPackage.getInstance()) != null) {
            instance.updateUIForHiddenComponents();
        }
        JFactory.refreshUI(className);
        PREFS.put(USER_PREFS_KEY, item.command);
    }

    @Override
    public void doAction(ActionEvent ev) {
        try {
            LookAndFeelCommand.activateLookAndFeel(ev.getActionCommand());
            int chosenOption = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("laf_quit_after_change"), JMeterUtils.getResString("exit"), 0, 3);
            if (chosenOption == 0) {
                ActionRouter.getInstance().doActionNow(new ActionEvent(ev.getSource(), ev.getID(), "restart"));
            }
        }
        catch (IllegalArgumentException e) {
            JMeterUtils.reportErrorToUser(e.getMessage(), e);
        }
    }

    @Override
    public Set<String> getActionNames() {
        return Collections.unmodifiableSet(items.keySet());
    }

    static {
        if (System.getProperty("darklaf.decorations") == null) {
            System.setProperty("darklaf.decorations", "false");
        } else if (Boolean.getBoolean("darklaf.allowNativeCode")) {
            System.setProperty("darklaf.decorations", "true");
        }
        if (System.getProperty("darklaf.allowNativeCode") == null) {
            System.setProperty("darklaf.allowNativeCode", "false");
        }
        if (System.getProperty("darklaf.unifiedMenuBar") == null) {
            System.setProperty("darklaf.unifiedMenuBar", "true");
        }
        if (System.getProperty("darklaf.treeRowPopup") == null) {
            System.setProperty("darklaf.treeRowPopup", "false");
        }
        UIManager.installLookAndFeel("Darcula", "com.bulenkov.darcula.DarculaLaf");
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (UIManager.LookAndFeelInfo laf : JMeterMenuBar.getAllLAFs()) {
            if (!laf.getClassName().equals("com.bulenkov.darcula.DarculaLaf")) {
                items.add(MenuItem.of(laf.getName(), laf.getClassName()));
                continue;
            }
            for (Theme theme : LafManager.getRegisteredThemes()) {
                items.add(MenuItem.ofDarklafTheme(theme));
            }
        }
        items.sort(Comparator.comparing(MenuItem::getTitle));
        for (MenuItem item : items) {
            LookAndFeelCommand.items.put(item.command, item);
        }
    }

    public static class MenuItem {
        final String title;
        final String command;
        final String lafClassName;
        final Theme lafTheme;

        private MenuItem(String title, String command, String lafClassName, Theme lafTheme) {
            this.title = title;
            this.command = command;
            this.lafClassName = lafClassName;
            this.lafTheme = lafTheme;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCommand() {
            return this.command;
        }

        private static MenuItem of(String title, String lafClass) {
            return new MenuItem(title, "laf:" + lafClass, lafClass, null);
        }

        private static MenuItem ofDarklafTheme(Theme theme) {
            return new MenuItem("Darklaf - " + theme.getName(), "com.github.weisj.darklaf.DarkLaf:" + theme.getThemeClass().getName(), "com.github.weisj.darklaf.DarkLaf", theme);
        }
    }
}

