/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.Searcher;

public class RegexpSearcher
implements Searcher {
    private boolean caseSensitive;
    private String regexp;

    public RegexpSearcher(boolean caseSensitive, String regexp) {
        this.caseSensitive = caseSensitive;
        this.regexp = regexp;
    }

    @Override
    public boolean search(List<String> textTokens) {
        Pattern pattern = this.caseSensitive ? Pattern.compile(this.regexp) : Pattern.compile(this.regexp, 2);
        return textTokens.stream().filter(token -> !StringUtils.isEmpty(token)).map(token -> this.caseSensitive ? pattern.matcher((CharSequence)token) : pattern.matcher(token.toLowerCase())).anyMatch(Matcher::find);
    }

    public String toString() {
        return "RegexpSearcher [caseSensitive=" + this.caseSensitive + ", regexp=" + this.regexp + "]";
    }
}

