/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action.validation;

import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeClonerForValidation
extends TreeCloner {
    private static final Logger log = LoggerFactory.getLogger(TreeClonerForValidation.class);
    protected static final int VALIDATION_NUMBER_OF_THREADS = JMeterUtils.getPropDefault("testplan_validation.nb_threads_per_thread_group", 1);
    protected static final boolean VALIDATION_IGNORE_TIMERS = JMeterUtils.getPropDefault("testplan_validation.ignore_timers", true);
    protected static final boolean VALIDATION_IGNORE_BACKENDS = JMeterUtils.getPropDefault("testplan_validation.ignore_backends", true);
    protected static final int VALIDATION_ITERATIONS = JMeterUtils.getPropDefault("testplan_validation.number_iterations", 1);

    public TreeClonerForValidation() {
        this(false);
    }

    public TreeClonerForValidation(boolean honourNoThreadClone) {
        super(honourNoThreadClone);
    }

    @Override
    protected Object addNodeToTree(Object node) {
        if (VALIDATION_IGNORE_TIMERS && node instanceof Timer || VALIDATION_IGNORE_BACKENDS && node instanceof Backend) {
            return node;
        }
        Object clonedNode = super.addNodeToTree(node);
        if (clonedNode instanceof ThreadGroup) {
            ThreadGroup tg = (ThreadGroup)clonedNode;
            tg.setNumThreads(VALIDATION_NUMBER_OF_THREADS);
            tg.setScheduler(false);
            tg.setProperty("ThreadGroup.delay", 0);
            if (((AbstractThreadGroup)clonedNode).getSamplerController() instanceof LoopController) {
                ((LoopController)((AbstractThreadGroup)clonedNode).getSamplerController()).setLoops(VALIDATION_ITERATIONS);
            }
        }
        return clonedNode;
    }

    static {
        log.info("Running validation with number of threads:{}, ignoreTimers:{}, number of iterations:{}", VALIDATION_NUMBER_OF_THREADS, VALIDATION_IGNORE_TIMERS, VALIDATION_ITERATIONS);
    }
}

