/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.logging;

import java.io.Serializable;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.logging.LogEventObject;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="GuiLogEvent", category="Core", elementType="appender", printObject=true)
public class GuiLogEventAppender
extends AbstractAppender {
    protected GuiLogEventAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    @Override
    public void append(LogEvent logEvent) {
        String serializedString;
        GuiPackage instance = GuiPackage.getInstance();
        if (instance != null && (serializedString = (String)this.getStringLayout().toSerializable(logEvent)) != null && !serializedString.isEmpty()) {
            LogEventObject logEventObject = new LogEventObject(logEvent, serializedString);
            instance.getLogEventBus().postEvent(logEventObject);
        }
    }

    @PluginFactory
    public static GuiLogEventAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for GuiLogEventAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new GuiLogEventAppender(name, filter, layout, ignoreExceptions);
    }

    public StringLayout getStringLayout() {
        return (StringLayout)this.getLayout();
    }
}

