/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public final class JSyntaxSearchToolBar
implements ActionListener {
    public static final Color LIGHT_RED = new Color(255, 128, 128);
    public static final String FIND_ACTION = "Find";
    private JToolBar toolBar;
    private JTextField searchField;
    private JCheckBox regexCB;
    private JCheckBox matchCaseCB;
    private JSyntaxTextArea dataField;

    public JSyntaxSearchToolBar(JSyntaxTextArea dataField) {
        this.dataField = dataField;
        this.init();
    }

    private void init() {
        this.searchField = new JTextField(30);
        JFactory.small(this.searchField);
        JButton findButton = new JButton(JMeterUtils.getResString("search_text_button_find"));
        JFactory.small(findButton);
        findButton.setActionCommand(FIND_ACTION);
        findButton.addActionListener(this);
        this.regexCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_regexp"));
        JFactory.small(this.regexCB);
        this.matchCaseCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_case"));
        JFactory.small(this.matchCaseCB);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        JFactory.small(this.toolBar);
        this.toolBar.add(this.searchField);
        this.toolBar.add(findButton);
        this.toolBar.add(this.matchCaseCB);
        this.toolBar.add(this.regexCB);
        this.searchField.addActionListener(e -> findButton.doClick(0));
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String text = this.searchField.getText();
        this.toggleSearchField(this.searchField, true);
        if (!text.isEmpty()) {
            SearchContext context = this.createSearchContext(text, true, this.matchCaseCB.isSelected(), this.regexCB.isSelected());
            boolean found = SearchEngine.find((JTextArea)((Object)this.dataField), (SearchContext)context).wasFound();
            this.toggleSearchField(this.searchField, found);
            if (!found) {
                this.dataField.setCaretPosition(0);
            }
        }
    }

    void toggleSearchField(JTextField textToFindField, boolean matchFound) {
        if (!matchFound) {
            textToFindField.setBackground(LIGHT_RED);
            textToFindField.setForeground(Color.WHITE);
        } else {
            textToFindField.setBackground(Color.WHITE);
            textToFindField.setForeground(Color.BLACK);
        }
    }

    private SearchContext createSearchContext(String text, boolean forward, boolean matchCase, boolean isRegex) {
        SearchContext context = new SearchContext();
        context.setSearchFor(text);
        context.setMatchCase(matchCase);
        context.setRegularExpression(isRegex);
        context.setSearchForward(forward);
        context.setMarkAll(false);
        context.setSearchSelectionOnly(false);
        context.setWholeWord(false);
        return context;
    }
}

