/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import com.github.weisj.darklaf.extensions.rsyntaxarea.DarklafRSyntaxTheme;
import java.awt.Color;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.LookAndFeelCommand;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;
import org.apache.jorphan.gui.JMeterUIDefaults;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RUndoManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSyntaxTextArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = 211L;
    private static final Logger log = LoggerFactory.getLogger(JSyntaxTextArea.class);
    private static final Theme DEFAULT_THEME = JSyntaxTextArea.loadTheme(Theme.class, "themes/default.xml");
    private final Properties languageProperties = JMeterUtils.loadProperties("org/apache/jmeter/gui/util/textarea.properties");
    private final boolean disableUndo;
    private static final boolean WRAP_STYLE_WORD = JMeterUtils.getPropDefault("jsyntaxtextarea.wrapstyleword", true);
    private static final boolean LINE_WRAP = JMeterUtils.getPropDefault("jsyntaxtextarea.linewrap", true);
    private static final boolean CODE_FOLDING = JMeterUtils.getPropDefault("jsyntaxtextarea.codefolding", true);
    private static final int MAX_UNDOS = JMeterUtils.getPropDefault("jsyntaxtextarea.maxundos", 50);
    private static final String USER_FONT_FAMILY = JMeterUtils.getPropDefault("jsyntaxtextarea.font.family", null);
    private static final int USER_FONT_SIZE = JMeterUtils.getPropDefault("jsyntaxtextarea.font.size", -1);
    private static final HierarchyListener GUTTER_THEME_PATCHER = e -> {
        if ((e.getChangeFlags() & 1L) != 0L && e.getChanged() instanceof JSyntaxTextArea) {
            SwingUtilities.invokeLater(() -> JSyntaxTextArea.applyTheme((JSyntaxTextArea)((Object)((Object)((Object)e.getChanged())))));
        }
    };

    public static JSyntaxTextArea getInstance(int rows, int cols, boolean disableUndo) {
        try {
            JSyntaxTextArea jSyntaxTextArea = new JSyntaxTextArea(rows, cols, disableUndo);
            JFactory.withDynamic(jSyntaxTextArea, JSyntaxTextArea::applyTheme);
            jSyntaxTextArea.addHierarchyListener(GUTTER_THEME_PATCHER);
            return jSyntaxTextArea;
        }
        catch (HeadlessException e) {
            if ("true".equals(System.getProperty("java.awt.headless"))) {
                return new JSyntaxTextArea(disableUndo){
                    private static final long serialVersionUID = 1L;

                    protected void init() {
                        try {
                            super.init();
                        }
                        catch (HeadlessException | NullPointerException runtimeException) {
                            // empty catch block
                        }
                    }

                    public void setCodeFoldingEnabled(boolean b) {
                    }

                    public void setCaretPosition(int b) {
                    }

                    public void discardAllEdits() {
                    }

                    public void setText(String t) {
                    }

                    public boolean isCodeFoldingEnabled() {
                        return true;
                    }
                };
            }
            throw e;
        }
    }

    private static void applyTheme(JSyntaxTextArea jSyntaxTextArea) {
        Color color;
        Theme theme;
        boolean isDarklafTheme = LookAndFeelCommand.isDarklafTheme();
        Object object = theme = isDarklafTheme ? new DarklafRSyntaxTheme((RSyntaxTextArea)jSyntaxTextArea) : DEFAULT_THEME;
        if (theme != null) {
            theme.apply((RSyntaxTextArea)jSyntaxTextArea);
            Font font = jSyntaxTextArea.getFont();
            float scale = JMeterUIDefaults.INSTANCE.getScale();
            if ((double)Math.abs(scale - 1.0f) > 0.01) {
                font = font.deriveFont(font.getSize2D() * scale);
                jSyntaxTextArea.setFont(font);
            }
        }
        if (!isDarklafTheme && (color = UIManager.getColor("TextArea.background")) != null) {
            jSyntaxTextArea.setBackground(color);
        }
    }

    public static JSyntaxTextArea getInstance(int rows, int cols) {
        return JSyntaxTextArea.getInstance(rows, cols, false);
    }

    @Deprecated
    public JSyntaxTextArea() {
        this(30, 50, false);
    }

    private JSyntaxTextArea(boolean dummy) {
        this.disableUndo = dummy;
    }

    @Deprecated
    public JSyntaxTextArea(int rows, int cols) {
        this(rows, cols, false);
    }

    @Deprecated
    public JSyntaxTextArea(int rows, int cols, boolean disableUndo) {
        super(rows, cols);
        super.setSyntaxEditingStyle("text/java");
        super.setCodeFoldingEnabled(CODE_FOLDING);
        super.setAntiAliasingEnabled(true);
        super.setLineWrap(LINE_WRAP);
        super.setWrapStyleWord(WRAP_STYLE_WORD);
        this.disableUndo = disableUndo;
        if (USER_FONT_FAMILY != null) {
            int fontSize = USER_FONT_SIZE > 0 ? USER_FONT_SIZE : this.getFont().getSize();
            this.setFont(JMeterUIDefaults.createFont(USER_FONT_FAMILY, 0, fontSize));
            if (log.isDebugEnabled()) {
                log.debug("Font is set to: {}", (Object)this.getFont());
            }
        }
        if (disableUndo) {
            this.discardAllEdits();
        }
    }

    public void setLanguage(String language) {
        if (language == null) {
            super.setSyntaxEditingStyle("text/plain");
        } else {
            String style = this.languageProperties.getProperty(language);
            if (style == null) {
                super.setSyntaxEditingStyle("text/plain");
            } else {
                super.setSyntaxEditingStyle(style);
            }
        }
    }

    protected RUndoManager createUndoManager() {
        RUndoManager undoManager = super.createUndoManager();
        if (this.disableUndo) {
            undoManager.setLimit(0);
        } else {
            undoManager.setLimit(MAX_UNDOS);
        }
        return undoManager;
    }

    public void setInitialText(String string) {
        this.setText(StringUtils.defaultString(string, ""));
        this.discardAllEdits();
    }

    private static Theme loadTheme(Class<?> klass, String name) {
        try {
            return Theme.load((InputStream)klass.getResourceAsStream(name));
        }
        catch (IOException e) {
            log.error("Error reading {} for JSyntaxTextArea", (Object)name, (Object)e);
            return null;
        }
    }
}

