/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.BSFTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSFPreProcessor
extends BSFTestElement
implements Cloneable,
PreProcessor,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BSFPreProcessor.class);
    private static final long serialVersionUID = 233L;

    @Override
    public void process() {
        BSFManager mgr = null;
        try {
            mgr = this.getManager();
            if (mgr == null) {
                return;
            }
            this.processFileOrScript(mgr);
        }
        catch (BSFException e) {
            if (log.isWarnEnabled()) {
                log.warn("Problem in BSF script. {}", (Object)e.toString());
            }
        }
        finally {
            if (mgr != null) {
                mgr.terminate();
            }
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

