/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterConfig
extends AbstractTestElement
implements Serializable,
LoopIterationListener,
NoThreadClone,
ThreadListener {
    private static final long serialVersionUID = 235L;
    private static final String START = "CounterConfig.start";
    private static final String END = "CounterConfig.end";
    private static final String INCREMENT = "CounterConfig.incr";
    private static final String FORMAT = "CounterConfig.format";
    private static final String PER_USER = "CounterConfig.per_user";
    private static final String VAR_NAME = "CounterConfig.name";
    private static final String RESET_ON_THREAD_GROUP_ITERATION = "CounterConfig.reset_on_tg_iteration";
    private static final boolean RESET_ON_THREAD_GROUP_ITERATION_DEFAULT = false;
    private long globalCounter = Long.MIN_VALUE;
    private transient ThreadLocal<Long> perTheadNumber;
    private transient ThreadLocal<Long> perTheadLastIterationNumber;
    private static final Logger log = LoggerFactory.getLogger(CounterConfig.class);

    private void init() {
        this.perTheadNumber = ThreadLocal.withInitial(this::getStart);
        this.perTheadLastIterationNumber = ThreadLocal.withInitial(() -> 1L);
    }

    public CounterConfig() {
        this.init();
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterationStart(LoopIterationEvent event) {
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        long start = this.getStart();
        long end = this.getEnd();
        long increment = this.getIncrement();
        if (!this.isPerUser()) {
            CounterConfig counterConfig = this;
            synchronized (counterConfig) {
                if (this.globalCounter == Long.MIN_VALUE || this.globalCounter > end) {
                    this.globalCounter = start;
                }
                variables.put(this.getVarName(), this.formatNumber(this.globalCounter));
                this.globalCounter += increment;
            }
        } else {
            long current = this.perTheadNumber.get();
            if (this.isResetOnThreadGroupIteration()) {
                Long lastIterationNumber;
                int iteration = variables.getIteration();
                if ((long)iteration != (lastIterationNumber = this.perTheadLastIterationNumber.get())) {
                    current = this.getStart();
                }
                this.perTheadLastIterationNumber.set(Long.valueOf(iteration));
            }
            variables.put(this.getVarName(), this.formatNumber(current));
            if ((current += increment) > end) {
                current = start;
            }
            this.perTheadNumber.set(current);
        }
    }

    private String formatNumber(long value) {
        String format = this.getFormat();
        if (format != null && format.length() > 0) {
            try {
                DecimalFormat myFormatter = new DecimalFormat(format);
                return myFormatter.format(value);
            }
            catch (IllegalArgumentException ignored) {
                log.warn("Error formatting {} at format {}, using default", (Object)value, (Object)format);
            }
        }
        return Long.toString(value);
    }

    public void setStart(long start) {
        this.setProperty(new LongProperty(START, start));
    }

    public void setStart(String start) {
        this.setProperty(START, start);
    }

    public long getStart() {
        return this.getPropertyAsLong(START);
    }

    public String getStartAsString() {
        return this.getPropertyAsString(START);
    }

    public void setEnd(long end) {
        this.setProperty(new LongProperty(END, end));
    }

    public void setEnd(String end) {
        this.setProperty(END, end);
    }

    public void setResetOnThreadGroupIteration(boolean value) {
        this.setProperty(RESET_ON_THREAD_GROUP_ITERATION, value, false);
    }

    public boolean isResetOnThreadGroupIteration() {
        return this.getPropertyAsBoolean(RESET_ON_THREAD_GROUP_ITERATION, false);
    }

    public long getEnd() {
        long propertyAsLong = this.getPropertyAsLong(END);
        if (propertyAsLong == 0L && "".equals(this.getProperty(END).getStringValue())) {
            propertyAsLong = Long.MAX_VALUE;
        }
        return propertyAsLong;
    }

    public String getEndAsString() {
        return this.getPropertyAsString(END);
    }

    public void setIncrement(long inc) {
        this.setProperty(new LongProperty(INCREMENT, inc));
    }

    public void setIncrement(String incr) {
        this.setProperty(INCREMENT, incr);
    }

    public long getIncrement() {
        return this.getPropertyAsLong(INCREMENT);
    }

    public String getIncrementAsString() {
        return this.getPropertyAsString(INCREMENT);
    }

    public void setIsPerUser(boolean isPer) {
        this.setProperty(new BooleanProperty(PER_USER, isPer));
    }

    public boolean isPerUser() {
        return this.getPropertyAsBoolean(PER_USER);
    }

    public void setVarName(String name) {
        this.setProperty(VAR_NAME, name);
    }

    public String getVarName() {
        return this.getPropertyAsString(VAR_NAME);
    }

    public void setFormat(String format) {
        this.setProperty(FORMAT, format);
    }

    public String getFormat() {
        return this.getPropertyAsString(FORMAT);
    }

    @Override
    public void threadStarted() {
    }

    @Override
    public void threadFinished() {
        this.perTheadLastIterationNumber.remove();
        this.perTheadNumber.remove();
    }
}

