/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleMonitor;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleTimeout
extends AbstractTestElement
implements Serializable,
ThreadListener,
SampleMonitor {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(SampleTimeout.class);
    private static final String TIMEOUT = "InterruptTimer.timeout";
    private ScheduledFuture<?> future;
    private final transient ScheduledExecutorService execService = SampleTimeout.getExecutorService();

    private static ScheduledExecutorService getExecutorService() {
        return TPOOLHolder.EXEC_SERVICE;
    }

    public SampleTimeout() {
        if (log.isDebugEnabled()) {
            log.debug(this.whoAmI("InterruptTimer()", this));
        }
    }

    public void setTimeout(String timeout) {
        this.setProperty(TIMEOUT, timeout);
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT);
    }

    @Override
    public void sampleStarting(Sampler sampler) {
        if (log.isDebugEnabled()) {
            log.debug(this.whoAmI("sampleStarting()", this));
        }
        this.createTask(sampler);
    }

    @Override
    public void sampleEnded(Sampler sampler) {
        if (log.isDebugEnabled()) {
            log.debug(this.whoAmI("sampleEnded()", this));
        }
        this.cancelTask();
    }

    private void createTask(Sampler samp) {
        long timeout = this.getPropertyAsLong(TIMEOUT);
        if (timeout <= 0L) {
            return;
        }
        if (!(samp instanceof Interruptible)) {
            return;
        }
        Interruptible sampler = (Interruptible)((Object)samp);
        Callable<Object> call = () -> {
            long start = System.nanoTime();
            boolean interrupted = sampler.interrupt();
            String elapsed = Double.toString((double)(System.nanoTime() - start) / 1.0E9) + " secs";
            if (interrupted) {
                if (log.isWarnEnabled()) {
                    log.warn("Call Done interrupting {} took {}", (Object)this.getInfo(samp), (Object)elapsed);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Call Didn't interrupt: {} took {}", (Object)this.getInfo(samp), (Object)elapsed);
            }
            return null;
        };
        this.future = this.execService.schedule(call, timeout, TimeUnit.MILLISECONDS);
        if (log.isDebugEnabled()) {
            log.debug("Scheduled timer: @{} {}", (Object)System.identityHashCode(this.future), (Object)this.getInfo(samp));
        }
    }

    @Override
    public void threadStarted() {
        if (log.isDebugEnabled()) {
            log.debug(this.whoAmI("threadStarted()", this));
        }
    }

    @Override
    public void threadFinished() {
        if (log.isDebugEnabled()) {
            log.debug(this.whoAmI("threadFinished()", this));
        }
        this.cancelTask();
    }

    public String toString() {
        return JMeterUtils.getResString("sample_timeout_memo");
    }

    private String whoAmI(String id, TestElement o) {
        return id + " @" + System.identityHashCode(o) + " '" + o.getName() + "' " + (log.isDebugEnabled() ? Thread.currentThread().getName() : "");
    }

    private String getInfo(TestElement o) {
        return this.whoAmI(o.getClass().getSimpleName(), o);
    }

    private void cancelTask() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                boolean cancelled = this.future.cancel(false);
                if (log.isDebugEnabled()) {
                    log.debug("Cancelled timer: @{}  with result {}", (Object)System.identityHashCode(this.future), (Object)cancelled);
                }
            }
            this.future = null;
        }
    }

    private static class TPOOLHolder {
        static final ScheduledExecutorService EXEC_SERVICE = Executors.newScheduledThreadPool(1, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });

        private TPOOLHolder() {
        }
    }
}

