/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserParameters
extends AbstractTestElement
implements Serializable,
PreProcessor,
LoopIterationListener {
    private static final Logger log = LoggerFactory.getLogger(UserParameters.class);
    private static final long serialVersionUID = 234L;
    public static final String NAMES = "UserParameters.names";
    public static final String THREAD_VALUES = "UserParameters.thread_values";
    public static final String PER_ITERATION = "UserParameters.per_iteration";
    private transient Object lock = new Object();

    private Object readResolve() {
        this.lock = new Object();
        return this;
    }

    public CollectionProperty getNames() {
        return (CollectionProperty)this.getProperty(NAMES);
    }

    public CollectionProperty getThreadLists() {
        return (CollectionProperty)this.getProperty(THREAD_VALUES);
    }

    public void setNames(Collection<?> list) {
        this.setProperty(new CollectionProperty(NAMES, list));
    }

    public void setNames(CollectionProperty list) {
        this.setProperty(list);
    }

    public void setThreadLists(Collection<?> threadLists) {
        this.setProperty(new CollectionProperty(THREAD_VALUES, threadLists));
    }

    public void setThreadLists(CollectionProperty threadLists) {
        this.setProperty(threadLists);
    }

    private CollectionProperty getValues() {
        CollectionProperty threadValues = (CollectionProperty)this.getProperty(THREAD_VALUES);
        if (threadValues.size() > 0) {
            return (CollectionProperty)threadValues.get(this.getThreadContext().getThreadNum() % threadValues.size());
        }
        return new CollectionProperty("noname", new ArrayList());
    }

    public boolean isPerIteration() {
        return this.getPropertyAsBoolean(PER_ITERATION);
    }

    public void setPerIteration(boolean perIter) {
        this.setProperty(new BooleanProperty(PER_ITERATION, perIter));
    }

    @Override
    public void process() {
        if (log.isDebugEnabled()) {
            log.debug("{} process {}", (Object)Thread.currentThread().getName(), (Object)this.isPerIteration());
        }
        if (!this.isPerIteration()) {
            this.setValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValues() {
        Object object = this.lock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug("{} Running up named: {}", (Object)Thread.currentThread().getName(), (Object)this.getName());
            }
            PropertyIterator namesIter = this.getNames().iterator();
            PropertyIterator valueIter = this.getValues().iterator();
            JMeterVariables jmvars = this.getThreadContext().getVariables();
            while (namesIter.hasNext() && valueIter.hasNext()) {
                String name = namesIter.next().getStringValue();
                String value = valueIter.next().getStringValue();
                if (log.isDebugEnabled()) {
                    log.debug("{} saving variable: {}={}", Thread.currentThread().getName(), name, value);
                }
                jmvars.put(name, value);
            }
        }
    }

    @Override
    public void iterationStart(LoopIterationEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("{} iteration start {}", (Object)Thread.currentThread().getName(), (Object)this.isPerIteration());
        }
        if (this.isPerIteration()) {
            this.setValues();
        }
    }

    @Override
    public Object clone() {
        UserParameters up = (UserParameters)super.clone();
        up.lock = this.lock;
        return up;
    }
}

