/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.modifiers.CounterConfig;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="counter_config_title")
public class CounterConfigGui
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JTextField startField;
    private JTextField incrField;
    private JTextField endField;
    private JTextField varNameField;
    private JTextField formatField;
    private JCheckBox resetCounterOnEachThreadGroupIteration;
    private JCheckBox perUserField;

    public CounterConfigGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "counter_config_title";
    }

    @Override
    public TestElement createTestElement() {
        CounterConfig config = new CounterConfig();
        this.modifyTestElement(config);
        return config;
    }

    @Override
    public void modifyTestElement(TestElement c) {
        if (c instanceof CounterConfig) {
            CounterConfig config = (CounterConfig)c;
            config.setStart(this.startField.getText());
            config.setEnd(this.endField.getText());
            config.setIncrement(this.incrField.getText());
            config.setVarName(this.varNameField.getText());
            config.setFormat(this.formatField.getText());
            config.setIsPerUser(this.perUserField.isSelected());
            config.setResetOnThreadGroupIteration(this.resetCounterOnEachThreadGroupIteration.isEnabled() && this.resetCounterOnEachThreadGroupIteration.isSelected());
        }
        super.configureTestElement(c);
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.startField.setText("");
        this.incrField.setText("");
        this.endField.setText("");
        this.varNameField.setText("");
        this.formatField.setText("");
        this.perUserField.setSelected(false);
        this.resetCounterOnEachThreadGroupIteration.setEnabled(false);
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        CounterConfig config = (CounterConfig)element;
        this.startField.setText(config.getStartAsString());
        this.endField.setText(config.getEndAsString());
        this.incrField.setText(config.getIncrementAsString());
        this.formatField.setText(config.getFormat());
        this.varNameField.setText(config.getVarName());
        this.perUserField.setSelected(config.isPerUser());
        if (config.isPerUser()) {
            this.resetCounterOnEachThreadGroupIteration.setEnabled(true);
            this.resetCounterOnEachThreadGroupIteration.setSelected(config.isResetOnThreadGroupIteration());
        } else {
            this.resetCounterOnEachThreadGroupIteration.setEnabled(false);
        }
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout());
        JPanel counterPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        this.startField = new JTextField(20);
        counterPanel.add(JMeterUtils.labelFor(this.startField, "start_value"));
        counterPanel.add(this.startField);
        this.incrField = new JTextField(20);
        counterPanel.add(JMeterUtils.labelFor(this.incrField, "increment"));
        counterPanel.add(this.incrField);
        this.endField = new JTextField(20);
        counterPanel.add(JMeterUtils.labelFor(this.endField, "max_value"));
        counterPanel.add(this.endField);
        this.formatField = new JTextField(20);
        counterPanel.add(JMeterUtils.labelFor(this.formatField, "format"));
        counterPanel.add(this.formatField);
        this.varNameField = new JTextField(20);
        counterPanel.add(JMeterUtils.labelFor(this.varNameField, "var_name"));
        counterPanel.add(this.varNameField);
        this.perUserField = new JCheckBox(JMeterUtils.getResString("counter_per_user"));
        this.perUserField.addActionListener(this);
        counterPanel.add((Component)this.perUserField, "span 2");
        this.resetCounterOnEachThreadGroupIteration = new JCheckBox(JMeterUtils.getResString("counter_reset_per_tg_iteration"));
        counterPanel.add((Component)this.resetCounterOnEachThreadGroupIteration, "span 2");
        this.add((Component)this.makeTitlePanel(), "North");
        this.add((Component)counterPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.perUserField) {
            this.resetCounterOnEachThreadGroupIteration.setEnabled(this.perUserField.isSelected());
        }
    }
}

