/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config.gui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.http.config.GraphQLRequestParams;
import org.apache.jmeter.protocol.http.config.gui.AbstractValidationTabbedPane;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigDefaults;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.util.GraphQLRequestParamUtils;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class GraphQLUrlConfigGui
extends UrlConfigGui {
    private static final long serialVersionUID = 1L;
    public static final String OPERATION_NAME = "GraphQLHTTPSampler.operationName";
    public static final String QUERY = "GraphQLHTTPSampler.query";
    public static final String VARIABLES = "GraphQLHTTPSampler.variables";
    private static final UrlConfigDefaults URL_CONFIG_DEFAULTS = new UrlConfigDefaults();
    private JLabeledTextField operationNameText;
    private JSyntaxTextArea queryContent;
    private JSyntaxTextArea variablesContent;

    public GraphQLUrlConfigGui() {
        super(true, false, false);
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        String operationName = element.getPropertyAsString(OPERATION_NAME, "");
        this.operationNameText.setText(operationName);
        String query = element.getPropertyAsString(QUERY, "");
        this.queryContent.setText(query);
        String variables = element.getPropertyAsString(VARIABLES, "");
        this.variablesContent.setText(variables);
    }

    @Override
    public void modifyTestElement(TestElement element) {
        Arguments args;
        super.modifyTestElement(element);
        String method = element.getPropertyAsString("HTTPSampler.method");
        GraphQLRequestParams params = new GraphQLRequestParams(this.operationNameText.getText(), this.queryContent.getText(), this.variablesContent.getText());
        element.setProperty(OPERATION_NAME, params.getOperationName());
        element.setProperty(QUERY, params.getQuery());
        element.setProperty(VARIABLES, params.getVariables());
        element.setProperty("HTTPSampler.postBodyRaw", !"GET".equals(method));
        if ("GET".equals(method)) {
            String variablesParamValue;
            args = this.createHTTPArgumentsTestElement();
            if (StringUtils.isNotBlank(params.getOperationName())) {
                args.addArgument(this.createHTTPArgument("operationName", params.getOperationName().trim(), true));
            }
            args.addArgument(this.createHTTPArgument("query", GraphQLRequestParamUtils.queryToGetParamValue(params.getQuery()), true));
            if (StringUtils.isNotBlank(params.getVariables()) && (variablesParamValue = GraphQLRequestParamUtils.variablesToGetParamValue(params.getVariables())) != null) {
                args.addArgument(this.createHTTPArgument("variables", variablesParamValue, true));
            }
        } else {
            args = new Arguments();
            args.addArgument(this.createHTTPArgument("", GraphQLRequestParamUtils.toPostBodyString(params), false));
        }
        element.setProperty(new TestElementProperty("HTTPsampler.Arguments", args));
    }

    @Override
    protected UrlConfigDefaults getUrlConfigDefaults() {
        return URL_CONFIG_DEFAULTS;
    }

    @Override
    protected Component getPathPanel() {
        JPanel panel = (JPanel)super.getPathPanel();
        HorizontalPanel graphQLReqInfoPane = new HorizontalPanel();
        graphQLReqInfoPane.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("graphql_request_info")));
        this.operationNameText = new JLabeledTextField(JMeterUtils.getResString("graphql_operation_name"), 40);
        ((Container)graphQLReqInfoPane).add(this.operationNameText);
        panel.add(graphQLReqInfoPane);
        return panel;
    }

    @Override
    protected JTabbedPane getParameterPanel() {
        AbstractValidationTabbedPane paramPanel = (AbstractValidationTabbedPane)super.getParameterPanel();
        paramPanel.removeAll();
        paramPanel.setValidationEnabled(false);
        this.queryContent = JSyntaxTextArea.getInstance(26, 50);
        this.queryContent.setInitialText("");
        paramPanel.add(JMeterUtils.getResString("graphql_query"), (Component)((Object)JTextScrollPane.getInstance(this.queryContent)));
        this.variablesContent = JSyntaxTextArea.getInstance(26, 50);
        this.variablesContent.setLanguage("json");
        this.variablesContent.setInitialText("");
        paramPanel.add(JMeterUtils.getResString("graphql_variables"), (Component)((Object)JTextScrollPane.getInstance(this.variablesContent)));
        return paramPanel;
    }

    private HTTPArgument createHTTPArgument(String name, String value, boolean alwaysEncoded) {
        HTTPArgument arg = new HTTPArgument(name, value);
        arg.setUseEquals(true);
        arg.setEnabled(true);
        arg.setAlwaysEncoded(alwaysEncoded);
        return arg;
    }

    static {
        URL_CONFIG_DEFAULTS.setValidMethods(new String[]{"POST", "GET"});
        URL_CONFIG_DEFAULTS.setDefaultMethod("POST");
        URL_CONFIG_DEFAULTS.setAutoRedirects(false);
        URL_CONFIG_DEFAULTS.setFollowRedirects(false);
        URL_CONFIG_DEFAULTS.setUseBrowserCompatibleMultipartMode(false);
        URL_CONFIG_DEFAULTS.setUseKeepAlive(true);
        URL_CONFIG_DEFAULTS.setUseMultipart(false);
        URL_CONFIG_DEFAULTS.setUseMultipartVisible(false);
    }
}

