/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.message.BasicHeader;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManager
extends ConfigTestElement
implements TestStateListener,
TestIterationListener,
Serializable {
    private static final long serialVersionUID = 236L;
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private static final Date EXPIRED_DATE = new Date(0L);
    private static final int DEFAULT_MAX_SIZE = 5000;
    private static final long ONE_YEAR_MS = 31536000000L;
    private static final String[] CACHEABLE_METHODS = JMeterUtils.getPropDefault("cacheable_methods", "GET").split("[ ,]");
    private static final String CONTROLLED_BY_THREAD = "CacheManager.controlledByThread";
    public static final String CLEAR = "clearEachIteration";
    public static final String USE_EXPIRES = "useExpires";
    public static final String MAX_SIZE = "maxSize";
    private transient InheritableThreadLocal<Map<String, CacheEntry>> threadCache;
    private transient boolean useExpires;
    private transient Map<String, CacheEntry> localCache;

    public CacheManager() {
        this.setProperty(new BooleanProperty(CLEAR, false));
        this.setProperty(new BooleanProperty(USE_EXPIRES, false));
        this.clearCache();
        this.useExpires = false;
    }

    CacheManager(Map<String, CacheEntry> localCache, boolean useExpires) {
        this.localCache = localCache;
        this.useExpires = useExpires;
    }

    public boolean getControlledByThread() {
        return this.getPropertyAsBoolean(CONTROLLED_BY_THREAD);
    }

    public void setControlledByThread(boolean control) {
        this.setProperty(new BooleanProperty(CONTROLLED_BY_THREAD, control));
    }

    public void saveDetails(URLConnection conn, HTTPSampleResult res) {
        String varyHeader = conn.getHeaderField("Vary");
        if (this.isCacheable(res, varyHeader)) {
            String lastModified = conn.getHeaderField("Last-Modified");
            String expires = conn.getHeaderField("Expires");
            String etag = conn.getHeaderField("Etag");
            String url = conn.getURL().toString();
            String cacheControl = conn.getHeaderField("Cache-Control");
            String date = conn.getHeaderField("Date");
            if (this.anyNotBlank(lastModified, expires, etag, cacheControl)) {
                this.setCache(lastModified, cacheControl, expires, etag, url, date, this.getVaryHeader(varyHeader, this.asHeaders(res.getRequestHeaders())));
            }
        }
    }

    private boolean anyNotBlank(String ... values) {
        for (String value : values) {
            if (!StringUtils.isNotBlank(value)) continue;
            return true;
        }
        return false;
    }

    private Pair<String, String> getVaryHeader(String headerName, org.apache.http.Header[] reqHeaders) {
        if (headerName == null) {
            return null;
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(headerName.split(",\\s*")));
        HashMap values = new HashMap();
        for (String name : names) {
            values.put(name, new ArrayList());
        }
        for (org.apache.http.Header header : reqHeaders) {
            if (!names.contains(header.getName())) continue;
            log.debug("Found vary value {} for {} in response", (Object)header, (Object)headerName);
            ((List)values.get(header.getName())).add(header.getValue());
        }
        return new ImmutablePair<String, String>(headerName, ((Object)values).toString());
    }

    public void saveDetails(HttpResponse method, HTTPSampleResult res) {
        String varyHeader = this.getHeader(method, "Vary");
        if (this.isCacheable(res, varyHeader)) {
            String lastModified = this.getHeader(method, "Last-Modified");
            String expires = this.getHeader(method, "Expires");
            String etag = this.getHeader(method, "Etag");
            String cacheControl = this.getHeader(method, "Cache-Control");
            String date = this.getHeader(method, "Date");
            if (this.anyNotBlank(lastModified, expires, etag, cacheControl)) {
                this.setCache(lastModified, cacheControl, expires, etag, res.getUrlAsString(), date, this.getVaryHeader(varyHeader, this.asHeaders(res.getRequestHeaders())));
            }
        }
    }

    private void setCache(String lastModified, String cacheControl, String expires, String etag, String url, String date, Pair<String, String> varyHeader) {
        log.debug("setCache({}, {}, {}, {}, {}, {}, {})", lastModified, cacheControl, expires, etag, url, date, varyHeader);
        Date expiresDate = null;
        if (this.useExpires) {
            String maxAge = "max-age=";
            if (cacheControl != null && cacheControl.contains("no-store")) {
                return;
            }
            if (expires != null) {
                expiresDate = this.extractExpiresDateFromExpires(expires);
            }
            if (cacheControl == null || !cacheControl.contains("no-cache")) {
                expiresDate = this.extractExpiresDateFromCacheControl(lastModified, cacheControl, expires, etag, url, date, "max-age=", expiresDate);
            }
        }
        if (varyHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug("Set entry into cache for url {} and vary {} ({})", url, varyHeader, this.varyUrl(url, varyHeader.getLeft(), varyHeader.getRight()));
            }
            this.getCache().put(url, new CacheEntry(lastModified, expiresDate, etag, varyHeader.getLeft()));
            this.getCache().put(this.varyUrl(url, varyHeader.getLeft(), varyHeader.getRight()), new CacheEntry(lastModified, expiresDate, etag, null));
        } else {
            if (this.getCache().get(url) != null) {
                log.debug("Entry for {} already in cache.", (Object)url);
                return;
            }
            CacheEntry cacheEntry = new CacheEntry(lastModified, expiresDate, etag, null);
            log.debug("Set entry {} into cache for url {}", (Object)url, (Object)cacheEntry);
            this.getCache().put(url, cacheEntry);
        }
    }

    private Date extractExpiresDateFromExpires(String expires) {
        Date expiresDate;
        try {
            expiresDate = DateUtils.parseDate(expires);
        }
        catch (IllegalArgumentException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to parse Expires: '{}', exception: {}", (Object)expires, (Object)e);
            }
            expiresDate = EXPIRED_DATE;
        }
        return expiresDate;
    }

    private Date extractExpiresDateFromCacheControl(String lastModified, String cacheControl, String expires, String etag, String url, String date, String maxAge, Date defaultExpiresDate) {
        if (cacheControl != null && cacheControl.contains(maxAge)) {
            long maxAgeInSecs = Long.parseLong(cacheControl.substring(cacheControl.indexOf(maxAge) + maxAge.length()).split("[, ]")[0]);
            return new Date(System.currentTimeMillis() + maxAgeInSecs * 1000L);
        }
        if (expires == null) {
            return this.calcExpiresDate(lastModified, cacheControl, expires, etag, url, date);
        }
        return defaultExpiresDate;
    }

    private Date calcExpiresDate(String lastModified, String cacheControl, String expires, String etag, String url, String date) {
        if (!StringUtils.isEmpty(lastModified) && !StringUtils.isEmpty(date)) {
            try {
                Date responseDate = DateUtils.parseDate(date);
                Date lastModifiedAsDate = DateUtils.parseDate(lastModified);
                return new Date(System.currentTimeMillis() + Math.round((double)(responseDate.getTime() - lastModifiedAsDate.getTime()) * 0.1));
            }
            catch (IllegalArgumentException e) {
                if (log.isWarnEnabled()) {
                    log.warn("Failed computing expiration date with following info:" + lastModified + "," + cacheControl + "," + expires + "," + etag + "," + url + "," + date);
                }
                return new Date(System.currentTimeMillis() + 31536000000L);
            }
        }
        return new Date(System.currentTimeMillis() + 31536000000L);
    }

    private String getHeader(HttpResponse method, String name) {
        org.apache.http.Header hdr = method.getLastHeader(name);
        return hdr != null ? hdr.getValue() : null;
    }

    private boolean isCacheable(HTTPSampleResult res, String varyHeader) {
        if ("*".equals(varyHeader)) {
            return false;
        }
        String responseCode = res.getResponseCode();
        return this.isCacheableMethod(res) && ("200".compareTo(responseCode) <= 0 && "299".compareTo(responseCode) >= 0 || "304".equals(responseCode));
    }

    private boolean isCacheableMethod(HTTPSampleResult res) {
        String resMethod = res.getHTTPMethod();
        for (String method : CACHEABLE_METHODS) {
            if (!method.equalsIgnoreCase(resMethod)) continue;
            return true;
        }
        return false;
    }

    public void setHeaders(URL url, HttpRequestBase request) {
        CacheEntry entry = this.getEntry(url.toString(), request.getAllHeaders());
        if (log.isDebugEnabled()) {
            log.debug("setHeaders for HTTP Method:{}(OAH) URL:{} Entry:{}", request.getMethod(), url.toString(), entry);
        }
        if (entry != null) {
            String etag;
            String lastModified = entry.getLastModified();
            if (lastModified != null) {
                request.setHeader("If-Modified-Since", lastModified);
            }
            if ((etag = entry.getEtag()) != null) {
                request.setHeader("If-None-Match", etag);
            }
        }
    }

    public void setHeaders(HttpURLConnection conn, Header[] headers, URL url) {
        CacheEntry entry = this.getEntry(url.toString(), headers != null ? this.asHeaders(headers) : new org.apache.http.Header[]{});
        if (log.isDebugEnabled()) {
            log.debug("setHeaders HTTP Method{}(Java) url:{} entry:{}", conn.getRequestMethod(), url.toString(), entry);
        }
        if (entry != null) {
            String etag;
            String lastModified = entry.getLastModified();
            if (lastModified != null) {
                conn.addRequestProperty("If-Modified-Since", lastModified);
            }
            if ((etag = entry.getEtag()) != null) {
                conn.addRequestProperty("If-None-Match", etag);
            }
        }
    }

    @Deprecated
    public boolean inCache(URL url) {
        return this.entryStillValid(url, this.getEntry(url.toString(), null));
    }

    public boolean inCache(URL url, org.apache.http.Header[] allHeaders) {
        return this.entryStillValid(url, this.getEntry(url.toString(), allHeaders));
    }

    public boolean inCache(URL url, Header[] allHeaders) {
        return this.entryStillValid(url, this.getEntry(url.toString(), this.asHeaders(allHeaders)));
    }

    private org.apache.http.Header[] asHeaders(Header[] allHeaders) {
        ArrayList<HeaderAdapter> result = new ArrayList<HeaderAdapter>(allHeaders.length);
        for (Header header : allHeaders) {
            result.add(new HeaderAdapter(header));
        }
        return result.toArray(new org.apache.http.Header[result.size()]);
    }

    private org.apache.http.Header[] asHeaders(String allHeaders) {
        ArrayList<BasicHeader> result = new ArrayList<BasicHeader>();
        for (String line : allHeaders.split("\\n")) {
            String[] splitted = line.split(": ", 2);
            if (splitted.length != 2) continue;
            result.add(new BasicHeader(splitted[0], splitted[1]));
        }
        return result.toArray(new org.apache.http.Header[result.size()]);
    }

    private boolean entryStillValid(URL url, CacheEntry entry) {
        log.debug("Check if entry {} is still valid for url {}", (Object)entry, (Object)url);
        if (entry != null && entry.getVaryHeader() == null) {
            Date expiresDate = entry.getExpires();
            if (expiresDate != null) {
                if (expiresDate.after(new Date())) {
                    log.debug("Expires= {} (Valid) for url {}", (Object)expiresDate, (Object)url);
                    return true;
                }
                log.debug("Expires= {} (Expired) for url {}", (Object)expiresDate, (Object)url);
            } else {
                log.debug("expiresDate is null for url {}", (Object)url);
            }
        }
        return false;
    }

    private CacheEntry getEntry(String url, org.apache.http.Header[] headers) {
        CacheEntry entry = this.getCache().get(url);
        log.debug("getEntry url:{} entry:{} header:{}", url, entry, headers);
        if (entry == null) {
            log.debug("No entry found for url {}", (Object)url);
            return null;
        }
        if (entry.getVaryHeader() == null) {
            log.debug("Entry {} with no vary found for url {}", (Object)entry, (Object)url);
            return entry;
        }
        if (headers == null) {
            if (log.isDebugEnabled()) {
                log.debug("Entry {} found, but it should depend on vary {} for url {}", entry, entry.getVaryHeader(), url);
            }
            return null;
        }
        Pair<String, String> varyPair = this.getVaryHeader(entry.getVaryHeader(), headers);
        if (varyPair != null) {
            if (log.isDebugEnabled()) {
                log.debug("Looking again for {} because of {} with vary: {} ({})", url, entry, entry.getVaryHeader(), varyPair);
            }
            return this.getEntry(this.varyUrl(url, entry.getVaryHeader(), varyPair.getRight()), null);
        }
        return null;
    }

    private String varyUrl(String url, String headerName, String headerValue) {
        return "vary-" + headerName + "-" + headerValue + "-" + url;
    }

    private Map<String, CacheEntry> getCache() {
        return this.localCache != null ? this.localCache : (Map)this.threadCache.get();
    }

    public boolean getClearEachIteration() {
        return this.getPropertyAsBoolean(CLEAR);
    }

    public void setClearEachIteration(boolean clear) {
        this.setProperty(new BooleanProperty(CLEAR, clear));
    }

    public boolean getUseExpires() {
        return this.getPropertyAsBoolean(USE_EXPIRES);
    }

    public void setUseExpires(boolean expires) {
        this.setProperty(new BooleanProperty(USE_EXPIRES, expires));
    }

    public int getMaxSize() {
        return this.getPropertyAsInt(MAX_SIZE, 5000);
    }

    public void setMaxSize(int size) {
        this.setProperty(MAX_SIZE, size, 5000);
    }

    @Override
    public void clear() {
        super.clear();
        this.clearCache();
    }

    private void clearCache() {
        log.debug("Clear cache");
        this.threadCache = new InheritableThreadLocal<Map<String, CacheEntry>>(){

            @Override
            protected Map<String, CacheEntry> initialValue() {
                LRUMap map = new LRUMap(CacheManager.this.getMaxSize());
                return Collections.synchronizedMap(map);
            }
        };
    }

    public CacheManager createCacheManagerProxy() {
        return new CacheManager(this.getCache(), this.useExpires);
    }

    @Override
    public void testStarted() {
    }

    @Override
    public void testEnded() {
    }

    @Override
    public void testStarted(String host) {
    }

    @Override
    public void testEnded(String host) {
    }

    @Override
    public void testIterationStart(LoopIterationEvent event) {
        JMeterVariables jMeterVariables = JMeterContextService.getContext().getVariables();
        if (this.getControlledByThread() && !jMeterVariables.isSameUserOnNextIteration() || !this.getControlledByThread() && this.getClearEachIteration()) {
            this.clearCache();
        }
        this.useExpires = this.getUseExpires();
    }

    static {
        if (log.isInfoEnabled()) {
            log.info("Will only cache the following methods: {}", (Object)Arrays.toString(CACHEABLE_METHODS));
        }
    }

    private static class HeaderAdapter
    implements org.apache.http.Header {
        private final Header delegate;

        public HeaderAdapter(Header delegate) {
            this.delegate = delegate;
        }

        @Override
        public HeaderElement[] getElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getValue() {
            return this.delegate.getValue();
        }
    }

    static class CacheEntry {
        private final String lastModified;
        private final String etag;
        private final Date expires;
        private final String varyHeader;

        @Deprecated
        public CacheEntry(String lastModified, Date expires, String etag) {
            this.lastModified = lastModified;
            this.etag = etag;
            this.expires = expires;
            this.varyHeader = null;
        }

        public CacheEntry(String lastModified, Date expires, String etag, String varyHeader) {
            this.lastModified = lastModified;
            this.etag = etag;
            this.expires = expires;
            this.varyHeader = varyHeader;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getEtag() {
            return this.etag;
        }

        public Date getExpires() {
            return this.expires;
        }

        public String getVaryHeader() {
            return this.varyHeader;
        }

        public String toString() {
            return "CacheEntry [lastModified=" + this.lastModified + ", etag=" + this.etag + ", expires=" + this.expires + ", varyHeader=" + this.varyHeader + "]";
        }
    }
}

