/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.impl.auth.SPNegoScheme;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DelegatingSPNegoScheme
extends SPNegoScheme {
    public DelegatingSPNegoScheme(boolean stripPort, boolean useCanonicalHostName) {
        super(stripPort, useCanonicalHostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) throws GSSException {
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
        GSSCredential gssCredential = credentials instanceof KerberosCredentials ? ((KerberosCredentials)credentials).getGSSCredential() : null;
        GSSContext gssContext = this.createDelegatingGSSContext(manager, oid, serverName, gssCredential);
        try {
            if (input != null) {
                byte[] byArray = gssContext.initSecContext(input, 0, input.length);
                return byArray;
            }
            byte[] byArray = gssContext.initSecContext(new byte[0], 0, 0);
            return byArray;
        }
        finally {
            gssContext.dispose();
        }
    }

    GSSContext createDelegatingGSSContext(GSSManager manager, Oid oid, GSSName serverName, GSSCredential gssCredential) throws GSSException {
        GSSContext gssContext = manager.createContext(serverName.canonicalize(oid), oid, gssCredential, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return gssContext;
    }
}

