/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMirrorThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(HttpMirrorThread.class);
    private static final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String REDIRECT = "redirect";
    private static final String STATUS = "status";
    private static final String VERBOSE = "v";
    private final Socket clientSocket;

    public HttpMirrorThread(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String headerString;
        ByteArrayOutputStream baos;
        int positionOfBody;
        int length;
        byte[] buffer;
        boolean isChunked;
        int contentLength;
        BufferedOutputStream out;
        BufferedInputStream in;
        block34: {
            log.debug("Starting thread");
            in = null;
            out = null;
            in = new BufferedInputStream(this.clientSocket.getInputStream());
            contentLength = -1;
            isChunked = false;
            buffer = new byte[1024];
            StringBuilder headers = new StringBuilder();
            length = 0;
            positionOfBody = 0;
            baos = new ByteArrayOutputStream();
            while (positionOfBody <= 0 && (length = in.read(buffer)) != -1) {
                log.debug("Write body");
                baos.write(buffer, 0, length);
                headers.append(new String(buffer, 0, length, ISO_8859_1));
                positionOfBody = HttpMirrorThread.getPositionOfBody(headers.toString());
            }
            baos.close();
            headerString = headers.toString();
            if (headerString.length() != 0 && headerString.indexOf(13) >= 0) break block34;
            log.error("Invalid request received:'{}'", (Object)headerString);
            JOrphanUtils.closeQuietly(out);
            JOrphanUtils.closeQuietly(in);
            JOrphanUtils.closeQuietly(this.clientSocket);
            return;
        }
        try {
            String transferEncodingHeaderValue;
            String sleepHeaderValue;
            String cookieHeaderValue;
            String headersValue;
            String responseStatusValue;
            boolean verbose;
            int querypos;
            log.debug("Received => '{}'", (Object)headerString);
            String firstLine = headerString.substring(0, headerString.indexOf(13));
            String[] requestParts = firstLine.split("\\s+");
            String requestMethod = requestParts[0];
            String requestPath = requestParts[1];
            HashMap<String, String> parameters = new HashMap<String, String>();
            if ("GET".equals(requestMethod) && (querypos = requestPath.indexOf(63)) >= 0) {
                String query;
                try {
                    URI uri = new URI(requestPath);
                    query = uri.getQuery();
                }
                catch (URISyntaxException e) {
                    log.warn(e.getMessage());
                    query = requestPath.substring(querypos + 1);
                }
                if (query != null) {
                    String[] params;
                    for (String param : params = query.split("&")) {
                        String[] parts = param.split("=", 2);
                        if (parts.length == 2) {
                            parameters.put(parts[0], parts[1]);
                            continue;
                        }
                        parameters.put(parts[0], "");
                    }
                }
            }
            if (verbose = parameters.containsKey(VERBOSE)) {
                System.out.println(firstLine);
                log.info(firstLine);
            }
            if ((responseStatusValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-ResponseStatus")) == null) {
                responseStatusValue = "200 OK";
            }
            if (parameters.containsKey(REDIRECT)) {
                responseStatusValue = "302 Temporary Redirect";
            }
            if (parameters.containsKey(STATUS)) {
                responseStatusValue = (String)parameters.get(STATUS);
            }
            log.debug("Write headers");
            out = new BufferedOutputStream(this.clientSocket.getOutputStream());
            out.write(("HTTP/1.0 " + responseStatusValue).getBytes(ISO_8859_1));
            out.write(CRLF);
            out.write("Content-Type: text/plain".getBytes(ISO_8859_1));
            out.write(CRLF);
            if (parameters.containsKey(REDIRECT)) {
                String redirectLocation = "Location: " + (String)parameters.get(REDIRECT);
                if (verbose) {
                    System.out.println(redirectLocation);
                    log.info(redirectLocation);
                }
                out.write(redirectLocation.getBytes(ISO_8859_1));
                out.write(CRLF);
            }
            if ((headersValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-SetHeaders")) != null) {
                String[] headersToSet;
                for (String string : headersToSet = headersValue.split("\\|")) {
                    out.write(string.getBytes(ISO_8859_1));
                    out.write(CRLF);
                }
            }
            String responseLengthValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-ResponseLength");
            int responseLength = -1;
            if (responseLengthValue != null) {
                responseLength = Integer.parseInt(responseLengthValue);
            }
            if ((cookieHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-SetCookie")) != null) {
                out.write("Set-Cookie: ".getBytes(ISO_8859_1));
                out.write(cookieHeaderValue.getBytes(ISO_8859_1));
                out.write(CRLF);
            }
            out.write(CRLF);
            out.flush();
            if (responseLength >= 0) {
                out.write(baos.toByteArray(), 0, Math.min(baos.toByteArray().length, responseLength));
            } else {
                out.write(baos.toByteArray());
            }
            String contentLengthHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "Content-Length");
            if (contentLengthHeaderValue != null) {
                contentLength = Integer.parseInt(contentLengthHeaderValue);
            }
            if ((sleepHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "X-Sleep")) != null) {
                TimeUnit.MILLISECONDS.sleep(Integer.parseInt(sleepHeaderValue));
            }
            if ((transferEncodingHeaderValue = HttpMirrorThread.getRequestHeaderValue(headerString, "transfer-encoding")) != null && !(isChunked = transferEncodingHeaderValue.equalsIgnoreCase("chunked"))) {
                log.error("Transfer-Encoding header set, the value is not supported : {}", (Object)transferEncodingHeaderValue);
            }
            length = 0;
            if (contentLength > 0) {
                int totalReadBytes = headerString.length() - positionOfBody - 2;
                log.debug("Reading, {} < {}", (Object)totalReadBytes, (Object)contentLength);
                while (totalReadBytes < contentLength && (length = in.read(buffer)) != -1) {
                    log.debug("Read bytes: {}", (Object)length);
                    out.write(buffer, 0, length);
                    log.debug("totalReadBytes: {}", (Object)(totalReadBytes += length));
                }
            } else if (isChunked) {
                log.debug("Chunked");
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
            } else {
                log.debug("Other");
                while (in.available() > 0 && (length = in.read(buffer)) != -1) {
                    log.debug("Read bytes: {}", (Object)length);
                    out.write(buffer, 0, length);
                }
            }
            log.debug("Flush");
            out.flush();
        }
        catch (IOException | InterruptedException e) {
            try {
                log.error("", e);
            }
            catch (Throwable throwable) {
                JOrphanUtils.closeQuietly(out);
                JOrphanUtils.closeQuietly(in);
                JOrphanUtils.closeQuietly(this.clientSocket);
                throw throwable;
            }
            JOrphanUtils.closeQuietly(out);
            JOrphanUtils.closeQuietly(in);
            JOrphanUtils.closeQuietly(this.clientSocket);
        }
        JOrphanUtils.closeQuietly(out);
        JOrphanUtils.closeQuietly(in);
        JOrphanUtils.closeQuietly(this.clientSocket);
        log.debug("End of Thread");
    }

    private static String getRequestHeaderValue(String requestHeaders, String headerName) {
        String expression;
        Pattern pattern;
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(requestHeaders, pattern = JMeterUtils.getPattern(expression = "^" + headerName + ":\\s+([^\\r\\n]+)", 32777))) {
            return localMatcher.getMatch().group(1);
        }
        return null;
    }

    private static int getPositionOfBody(String stringToCheck) {
        String regularExpression;
        Pattern pattern;
        PatternMatcherInput input;
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(input = new PatternMatcherInput(stringToCheck), pattern = JMeterUtils.getPattern(regularExpression = "^\\r$", 32777))) {
            MatchResult match = localMatcher.getMatch();
            return match.beginOffset(0);
        }
        return -1;
    }
}

