/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.protocol.http.control.HttpMirrorControl;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="httpmirror_title", actionGroups={"menu_non_test_elements"})
public class HttpMirrorControlGui
extends LogicControllerGui
implements JMeterGUIComponent,
ActionListener,
UnsharedComponent {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(HttpMirrorControlGui.class);
    private JTextField portField;
    private JTextField maxPoolSizeField;
    private JTextField maxQueueSizeField;
    private JButton stop;
    private JButton start;
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_START = "start";
    private HttpMirrorControl mirrorController;

    public HttpMirrorControlGui() {
        log.debug("Creating HttpMirrorControlGui");
        this.init();
    }

    @Override
    public TestElement createTestElement() {
        this.mirrorController = new HttpMirrorControl();
        log.debug("creating/configuring model = {}", (Object)this.mirrorController);
        this.modifyTestElement(this.mirrorController);
        return this.mirrorController;
    }

    @Override
    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof HttpMirrorControl) {
            this.mirrorController = (HttpMirrorControl)el;
            this.mirrorController.setPort(this.portField.getText());
            this.mirrorController.setMaxPoolSize(this.maxPoolSizeField.getText());
            this.mirrorController.setMaxQueueSize(this.maxQueueSizeField.getText());
        }
    }

    @Override
    public String getLabelResource() {
        return "httpmirror_title";
    }

    @Override
    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    @Override
    public void configure(TestElement element) {
        log.debug("Configuring gui with {}", (Object)element);
        super.configure(element);
        this.mirrorController = (HttpMirrorControl)element;
        this.portField.setText(this.mirrorController.getPortString());
        this.maxPoolSizeField.setText(this.mirrorController.getMaxPoolSizeAsString());
        this.maxQueueSizeField.setText(this.mirrorController.getMaxQueueSizeAsString());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (command.equals(ACTION_STOP)) {
            this.mirrorController.stopHttpMirror();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
        } else if (command.equals(ACTION_START)) {
            this.modifyTestElement(this.mirrorController);
            this.mirrorController.startHttpMirror();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        Box myBox = Box.createVerticalBox();
        myBox.add(this.createPortPanel());
        mainPanel.add((Component)myBox, "North");
        mainPanel.add((Component)this.createControls(), "Center");
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createControls() {
        this.start = new JButton(JMeterUtils.getResString(ACTION_START));
        this.start.addActionListener(this);
        this.start.setActionCommand(ACTION_START);
        this.start.setEnabled(true);
        this.stop = new JButton(JMeterUtils.getResString(ACTION_STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(ACTION_STOP);
        this.stop.setEnabled(false);
        JPanel panel = new JPanel();
        panel.add(this.start);
        panel.add(this.stop);
        return panel;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField(HttpMirrorControl.DEFAULT_PORT_S, 8);
        this.portField.setName("HttpMirrorControlGui.port");
        JLabel label = new JLabel(JMeterUtils.getResString("port"));
        label.setLabelFor(this.portField);
        this.maxPoolSizeField = new JTextField(Integer.toString(0), 8);
        this.maxPoolSizeField.setName("HttpMirrorControlGui.maxPoolSize");
        JLabel mpsLabel = new JLabel(JMeterUtils.getResString("httpmirror_max_pool_size"));
        mpsLabel.setLabelFor(this.maxPoolSizeField);
        this.maxQueueSizeField = new JTextField(Integer.toString(25), 8);
        this.maxQueueSizeField.setName("HttpMirrorControlGui.maxQueueSize");
        JLabel mqsLabel = new JLabel(JMeterUtils.getResString("httpmirror_max_queue_size"));
        mqsLabel.setLabelFor(this.maxQueueSizeField);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("httpmirror_settings")));
        panel.add(label);
        panel.add(this.portField);
        panel.add(mpsLabel);
        panel.add(this.maxPoolSizeField);
        panel.add(mqsLabel);
        panel.add(this.maxQueueSizeField);
        panel.add(Box.createHorizontalStrut(10));
        return panel;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.portField.setText(HttpMirrorControl.DEFAULT_PORT_S);
        this.maxPoolSizeField.setText(Integer.toString(0));
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }
}

