/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.http.config.gui.UrlConfigGui;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;

@GUIMenuSortOrder(value=1)
@TestElementMetadata(labelResource="web_testing_title")
public class HttpTestSampleGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 242L;
    private UrlConfigGui urlConfigGui;
    private JCheckBox retrieveEmbeddedResources;
    private JCheckBox concurrentDwn;
    private JTextField concurrentPool;
    private JCheckBox useMD5;
    private JTextField embeddedAllowRE;
    private JTextField embeddedExcludeRE;
    private JTextField sourceIpAddr;
    private JComboBox<String> sourceIpType = new JComboBox<String>(HTTPSamplerBase.getSourceTypeList());
    private JTextField proxyScheme;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JTextField proxyUser;
    private JPasswordField proxyPass;
    private JComboBox<String> httpImplementation = new JComboBox<String>(HTTPSamplerFactory.getImplementations());
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;
    private final boolean isAJP;

    public HttpTestSampleGui() {
        this.isAJP = false;
        this.init();
    }

    protected HttpTestSampleGui(boolean ajp) {
        this.isAJP = ajp;
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)element;
        this.urlConfigGui.configure(element);
        this.retrieveEmbeddedResources.setSelected(samplerBase.isImageParser());
        this.concurrentDwn.setSelected(samplerBase.isConcurrentDwn());
        this.concurrentPool.setText(samplerBase.getConcurrentPool());
        this.useMD5.setSelected(samplerBase.useMD5());
        this.embeddedAllowRE.setText(samplerBase.getEmbeddedUrlRE());
        this.embeddedExcludeRE.setText(samplerBase.getEmbededUrlExcludeRE());
        if (!this.isAJP) {
            this.sourceIpAddr.setText(samplerBase.getIpSource());
            this.sourceIpType.setSelectedIndex(samplerBase.getIpSourceType());
            this.proxyScheme.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyScheme"));
            this.proxyHost.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyHost"));
            this.proxyPort.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyPort"));
            this.proxyUser.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyUser"));
            this.proxyPass.setText(samplerBase.getPropertyAsString("HTTPSampler.proxyPass"));
            this.httpImplementation.setSelectedItem(samplerBase.getPropertyAsString("HTTPSampler.implementation"));
            this.connectTimeOut.setText(samplerBase.getPropertyAsString("HTTPSampler.connect_timeout"));
            this.responseTimeOut.setText(samplerBase.getPropertyAsString("HTTPSampler.response_timeout"));
        }
    }

    @Override
    public TestElement createTestElement() {
        HTTPSamplerProxy sampler = new HTTPSamplerProxy();
        this.modifyTestElement(sampler);
        return sampler;
    }

    @Override
    public void modifyTestElement(TestElement sampler) {
        sampler.clear();
        this.urlConfigGui.modifyTestElement(sampler);
        HTTPSamplerBase samplerBase = (HTTPSamplerBase)sampler;
        samplerBase.setImageParser(this.retrieveEmbeddedResources.isSelected());
        this.enableConcurrentDwn(this.retrieveEmbeddedResources.isSelected());
        samplerBase.setConcurrentDwn(this.concurrentDwn.isSelected());
        samplerBase.setConcurrentPool(this.concurrentPool.getText());
        samplerBase.setMD5(this.useMD5.isSelected());
        samplerBase.setEmbeddedUrlRE(this.embeddedAllowRE.getText());
        samplerBase.setEmbeddedUrlExcludeRE(this.embeddedExcludeRE.getText());
        if (!this.isAJP) {
            samplerBase.setIpSource(this.sourceIpAddr.getText());
            samplerBase.setIpSourceType(this.sourceIpType.getSelectedIndex());
            samplerBase.setProperty("HTTPSampler.proxyScheme", this.proxyScheme.getText(), "");
            samplerBase.setProperty("HTTPSampler.proxyHost", this.proxyHost.getText(), "");
            samplerBase.setProperty("HTTPSampler.proxyPort", this.proxyPort.getText(), "");
            samplerBase.setProperty("HTTPSampler.proxyUser", this.proxyUser.getText(), "");
            samplerBase.setProperty("HTTPSampler.proxyPass", String.valueOf(this.proxyPass.getPassword()), "");
            samplerBase.setProperty("HTTPSampler.implementation", this.httpImplementation.getSelectedItem().toString(), "");
            samplerBase.setProperty("HTTPSampler.connect_timeout", this.connectTimeOut.getText());
            samplerBase.setProperty("HTTPSampler.response_timeout", this.responseTimeOut.getText());
        }
        super.configureTestElement(sampler);
    }

    @Override
    public String getLabelResource() {
        return "web_testing_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder());
        JTabbedPane tabbedPane = this.createTabbedConfigPane();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder(this.makeBorder());
        wrapper.add((Component)this.makeTitlePanel(), "Center");
        JSplitPane splitPane = new JSplitPane(0, wrapper, tabbedPane);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setOneTouchExpandable(true);
        this.add(splitPane);
    }

    protected JTabbedPane createTabbedConfigPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.urlConfigGui = this.createUrlConfigGui();
        tabbedPane.add(JMeterUtils.getResString("web_testing_basic"), this.urlConfigGui);
        JPanel advancedPanel = this.createAdvancedConfigPanel();
        tabbedPane.add(JMeterUtils.getResString("web_testing_advanced"), advancedPanel);
        return tabbedPane;
    }

    protected UrlConfigGui createUrlConfigGui() {
        UrlConfigGui configGui = new UrlConfigGui(true, true, true);
        configGui.setBorder(this.makeBorder());
        return configGui;
    }

    private JPanel createAdvancedConfigPanel() {
        HorizontalPanel httpOptions = new HorizontalPanel();
        ((Container)httpOptions).add(this.getImplementationPanel());
        ((Container)httpOptions).add(this.getTimeOutPanel());
        VerticalPanel advancedPanel = new VerticalPanel();
        advancedPanel.setBorder(this.makeBorder());
        if (!this.isAJP) {
            ((Container)advancedPanel).add(httpOptions);
        }
        ((Container)advancedPanel).add(this.createEmbeddedRsrcPanel());
        if (!this.isAJP) {
            ((Container)advancedPanel).add(this.createSourceAddrPanel());
            ((Container)advancedPanel).add(this.getProxyServerPanel());
        }
        ((Container)advancedPanel).add(this.createOptionalTasksPanel());
        return advancedPanel;
    }

    private JPanel getTimeOutPanel() {
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        ((Container)timeOut).add(connPanel);
        ((Container)timeOut).add(reqPanel);
        return timeOut;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }

    protected JPanel createEmbeddedRsrcPanel() {
        this.retrieveEmbeddedResources = new JCheckBox(JMeterUtils.getResString("web_testing_retrieve_images"));
        this.retrieveEmbeddedResources.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.enableConcurrentDwn(true);
            } else {
                this.enableConcurrentDwn(false);
            }
        });
        this.concurrentDwn = new JCheckBox(JMeterUtils.getResString("web_testing_concurrent_download"));
        this.concurrentDwn.addItemListener(e -> {
            if (this.retrieveEmbeddedResources.isSelected() && e.getStateChange() == 1) {
                this.concurrentPool.setEnabled(true);
            } else {
                this.concurrentPool.setEnabled(false);
            }
        });
        this.concurrentPool = new JTextField(2);
        this.concurrentPool.setMinimumSize(new Dimension(10, (int)this.concurrentPool.getPreferredSize().getHeight()));
        this.concurrentPool.setMaximumSize(new Dimension(60, (int)this.concurrentPool.getPreferredSize().getHeight()));
        JPanel embeddedRsrcPanel = new JPanel((LayoutManager)new MigLayout());
        embeddedRsrcPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("web_testing_retrieve_title")));
        embeddedRsrcPanel.add(this.retrieveEmbeddedResources);
        embeddedRsrcPanel.add(this.concurrentDwn);
        embeddedRsrcPanel.add((Component)this.concurrentPool, "wrap");
        this.embeddedAllowRE = this.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString("web_testing_embedded_url_pattern"));
        this.embeddedExcludeRE = this.addTextFieldWithLabel(embeddedRsrcPanel, JMeterUtils.getResString("web_testing_embedded_url_exclude_pattern"));
        return embeddedRsrcPanel;
    }

    private JTextField addTextFieldWithLabel(JPanel panel, String labelText) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(100);
        label.setLabelFor(field);
        panel.add(label);
        panel.add((Component)field, "span");
        return field;
    }

    protected final JPanel getImplementationPanel() {
        HorizontalPanel implPanel = new HorizontalPanel();
        implPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("web_server_client")));
        ((Container)implPanel).add(new JLabel(JMeterUtils.getResString("http_implementation")));
        this.httpImplementation.addItem("");
        ((Container)implPanel).add(this.httpImplementation);
        return implPanel;
    }

    protected JPanel createOptionalTasksPanel() {
        VerticalPanel checkBoxPanel = new VerticalPanel();
        checkBoxPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("optional_tasks")));
        this.useMD5 = new JCheckBox(JMeterUtils.getResString("response_save_as_md5"));
        ((Container)checkBoxPanel).add(this.useMD5);
        return checkBoxPanel;
    }

    protected JPanel createSourceAddrPanel() {
        HorizontalPanel sourceAddrPanel = new HorizontalPanel();
        sourceAddrPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("web_testing_source_ip")));
        this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
        ((Container)sourceAddrPanel).add(this.sourceIpType);
        this.sourceIpAddr = new JTextField();
        ((Container)sourceAddrPanel).add(this.sourceIpAddr);
        return sourceAddrPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.retrieveEmbeddedResources.setSelected(false);
        this.concurrentDwn.setSelected(false);
        this.concurrentPool.setText(String.valueOf(6));
        this.enableConcurrentDwn(false);
        this.useMD5.setSelected(false);
        this.urlConfigGui.clear();
        this.embeddedAllowRE.setText("");
        if (!this.isAJP) {
            this.sourceIpAddr.setText("");
            this.sourceIpType.setSelectedIndex(HTTPSamplerBase.SourceType.HOSTNAME.ordinal());
            this.proxyScheme.setText("");
            this.proxyHost.setText("");
            this.proxyPort.setText("");
            this.proxyUser.setText("");
            this.proxyPass.setText("");
            this.httpImplementation.setSelectedItem("");
            this.connectTimeOut.setText("");
            this.responseTimeOut.setText("");
        }
    }

    private void enableConcurrentDwn(boolean enable) {
        this.concurrentDwn.setEnabled(enable);
        this.embeddedAllowRE.setEnabled(enable);
        this.embeddedExcludeRE.setEnabled(enable);
        this.concurrentPool.setEnabled(this.concurrentDwn.isSelected() && enable);
    }

    protected final JPanel getProxyServerPanel() {
        HorizontalPanel proxyServer = new HorizontalPanel();
        proxyServer.add((Component)this.getProxySchemePanel(), "West");
        proxyServer.add((Component)this.getProxyHostPanel(), "Center");
        proxyServer.add((Component)this.getProxyPortPanel(), "East");
        HorizontalPanel proxyLogin = new HorizontalPanel();
        ((Container)proxyLogin).add(this.getProxyUserPanel());
        ((Container)proxyLogin).add(this.getProxyPassPanel());
        HorizontalPanel proxyServerPanel = new HorizontalPanel();
        proxyServerPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("web_proxy_server_title")));
        ((Container)proxyServerPanel).add(proxyServer);
        ((Container)proxyServerPanel).add(proxyLogin);
        return proxyServerPanel;
    }

    private JPanel getProxySchemePanel() {
        this.proxyScheme = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString("web_proxy_scheme"));
        label.setLabelFor(this.proxyScheme);
        JFactory.small(label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyScheme, "Center");
        return panel;
    }

    private JPanel getProxyHostPanel() {
        this.proxyHost = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_domain"));
        label.setLabelFor(this.proxyHost);
        JFactory.small(label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyHost, "Center");
        return panel;
    }

    private JPanel getProxyPortPanel() {
        this.proxyPort = new JTextField(10);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_port"));
        label.setLabelFor(this.proxyPort);
        JFactory.small(label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPort, "Center");
        return panel;
    }

    private JPanel getProxyUserPanel() {
        this.proxyUser = new JTextField(5);
        JLabel label = new JLabel(JMeterUtils.getResString("username"));
        label.setLabelFor(this.proxyUser);
        JFactory.small(label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyUser, "Center");
        return panel;
    }

    private JPanel getProxyPassPanel() {
        this.proxyPass = new JPasswordField(5);
        JLabel label = new JLabel(JMeterUtils.getResString("password"));
        label.setLabelFor(this.proxyPass);
        JFactory.small(label);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.proxyPass, "Center");
        return panel;
    }
}

