/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnchorModifier
extends AbstractTestElement
implements PreProcessor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AnchorModifier.class);
    private static final long serialVersionUID = 240L;

    @Override
    public void process() {
        JMeterContext context = this.getThreadContext();
        Sampler sam = context.getCurrentSampler();
        SampleResult res = context.getPreviousResult();
        if (!(sam instanceof HTTPSamplerBase) || !(res instanceof HTTPSampleResult)) {
            log.info("Can't apply HTML Link Parser when the previous sampler run is not an HTTP Request.");
            return;
        }
        HTTPSamplerBase sampler = (HTTPSamplerBase)sam;
        HTTPSampleResult result = (HTTPSampleResult)res;
        ArrayList<HTTPSamplerBase> potentialLinks = new ArrayList<HTTPSamplerBase>();
        String responseText = result.getResponseDataAsString();
        int index = responseText.indexOf(60);
        if (index == -1) {
            index = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug("Check for matches against: " + sampler.toString());
        }
        Document html = (Document)HtmlParsingUtils.getDOM(responseText.substring(index));
        this.addAnchorUrls(html, result, sampler, potentialLinks);
        this.addFormUrls(html, result, sampler, potentialLinks);
        this.addFramesetUrls(html, result, sampler, potentialLinks);
        if (!potentialLinks.isEmpty()) {
            HTTPSamplerBase url = (HTTPSamplerBase)potentialLinks.get(ThreadLocalRandom.current().nextInt(potentialLinks.size()));
            if (log.isDebugEnabled()) {
                log.debug("Selected: " + url.toString());
            }
            sampler.setDomain(url.getDomain());
            sampler.setPath(url.getPath());
            if (url.getMethod().equals("POST")) {
                for (JMeterProperty jMeterProperty : sampler.getArguments()) {
                    Argument arg = (Argument)jMeterProperty.getObjectValue();
                    this.modifyArgument(arg, url.getArguments());
                }
            } else {
                sampler.setArguments(url.getArguments());
            }
            sampler.setProtocol(url.getProtocol());
        } else {
            log.debug("No matches found");
        }
    }

    private void modifyArgument(Argument arg, Arguments args) {
        Argument replacementArg;
        if (log.isDebugEnabled()) {
            log.debug("Modifying argument: " + arg);
        }
        ArrayList<Argument> possibleReplacements = new ArrayList<Argument>();
        PropertyIterator iter = args.iterator();
        while (iter.hasNext()) {
            replacementArg = (Argument)iter.next().getObjectValue();
            try {
                if (!HtmlParsingUtils.isArgumentMatched(replacementArg, arg)) continue;
                possibleReplacements.add(replacementArg);
            }
            catch (Exception ex) {
                log.error("Problem adding Argument", ex);
            }
        }
        if (!possibleReplacements.isEmpty()) {
            replacementArg = (Argument)possibleReplacements.get(ThreadLocalRandom.current().nextInt(possibleReplacements.size()));
            arg.setName(replacementArg.getName());
            arg.setValue(replacementArg.getValue());
            if (log.isDebugEnabled()) {
                log.debug("Just set argument to values: " + arg.getName() + " = " + arg.getValue());
            }
            args.removeArgument(replacementArg);
        }
    }

    public void addConfigElement(ConfigElement config) {
    }

    private void addFormUrls(Document html, HTTPSampleResult result, HTTPSamplerBase config, List<HTTPSamplerBase> potentialLinks) {
        NodeList rootList = html.getChildNodes();
        ArrayList<HTTPSamplerBase> urls = new ArrayList<HTTPSamplerBase>();
        for (int x = 0; x < rootList.getLength(); ++x) {
            urls.addAll(HtmlParsingUtils.createURLFromForm(rootList.item(x), result.getURL()));
        }
        for (HTTPSamplerBase newUrl : urls) {
            newUrl.setMethod("POST");
            if (log.isDebugEnabled()) {
                log.debug("Potential Form match: " + newUrl.toString());
            }
            if (!HtmlParsingUtils.isAnchorMatched(newUrl, config)) continue;
            log.debug("Matched!");
            potentialLinks.add(newUrl);
        }
    }

    private void addAnchorUrls(Document html, HTTPSampleResult result, HTTPSamplerBase config, List<HTTPSamplerBase> potentialLinks) {
        String base = "";
        NodeList baseList = html.getElementsByTagName("base");
        if (baseList.getLength() > 0) {
            base = baseList.item(0).getAttributes().getNamedItem("href").getNodeValue();
        }
        NodeList nodeList = html.getElementsByTagName("a");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String hrefStr;
            Node tempNode = nodeList.item(i);
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = nnm.getNamedItem("href");
            if (namedItem == null || (hrefStr = namedItem.getNodeValue()).startsWith("javascript:")) continue;
            try {
                HTTPSamplerBase newUrl = HtmlParsingUtils.createUrlFromAnchor(hrefStr, ConversionUtils.makeRelativeURL(result.getURL(), base));
                newUrl.setMethod("GET");
                if (log.isDebugEnabled()) {
                    log.debug("Potential <a href> match: " + newUrl);
                }
                if (!HtmlParsingUtils.isAnchorMatched(newUrl, config)) continue;
                log.debug("Matched!");
                potentialLinks.add(newUrl);
                continue;
            }
            catch (MalformedURLException e) {
                log.warn("Bad URL " + e);
            }
        }
    }

    private void addFramesetUrls(Document html, HTTPSampleResult result, HTTPSamplerBase config, List<HTTPSamplerBase> potentialLinks) {
        String base = "";
        NodeList baseList = html.getElementsByTagName("base");
        if (baseList.getLength() > 0) {
            base = baseList.item(0).getAttributes().getNamedItem("href").getNodeValue();
        }
        NodeList nodeList = html.getElementsByTagName("frame");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tempNode = nodeList.item(i);
            NamedNodeMap nnm = tempNode.getAttributes();
            Node namedItem = nnm.getNamedItem("src");
            if (namedItem == null) continue;
            String hrefStr = namedItem.getNodeValue();
            try {
                HTTPSamplerBase newUrl = HtmlParsingUtils.createUrlFromAnchor(hrefStr, ConversionUtils.makeRelativeURL(result.getURL(), base));
                newUrl.setMethod("GET");
                if (log.isDebugEnabled()) {
                    log.debug("Potential <frame src> match: " + newUrl);
                }
                if (!HtmlParsingUtils.isAnchorMatched(newUrl, config)) continue;
                log.debug("Matched!");
                potentialLinks.add(newUrl);
                continue;
            }
            catch (MalformedURLException e) {
                log.warn("Bad URL " + e);
            }
        }
    }
}

