/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.protocol.http.proxy.DefaultSamplerCreator;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.SamplerCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplerCreatorFactory {
    private static final Logger log = LoggerFactory.getLogger(SamplerCreatorFactory.class);
    private static final SamplerCreator DEFAULT_SAMPLER_CREATOR = new DefaultSamplerCreator();
    private final Map<String, SamplerCreator> samplerCreatorMap = new HashMap<String, SamplerCreator>();

    public SamplerCreatorFactory() {
        this.init();
    }

    public void setCounter(int value) {
        DEFAULT_SAMPLER_CREATOR.setCounter(value);
        for (SamplerCreator samplerCreator : this.samplerCreatorMap.values()) {
            samplerCreator.setCounter(value);
        }
    }

    private void init() {
        try {
            List<String> listClasses = ClassFinder.findClassesThatExtend(JMeterUtils.getSearchPaths(), new Class[]{SamplerCreator.class});
            for (String strClassName : listClasses) {
                try {
                    String[] contentTypes;
                    Class<?> commandClass;
                    if (log.isDebugEnabled()) {
                        log.debug("Loading class: {}", (Object)strClassName);
                    }
                    if (Modifier.isAbstract((commandClass = Class.forName(strClassName)).getModifiers())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Instantiating: {}", (Object)commandClass.getName());
                    }
                    SamplerCreator creator = (SamplerCreator)commandClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (String contentType : contentTypes = creator.getManagedContentTypes()) {
                        SamplerCreator oldSamplerCreator;
                        if (log.isDebugEnabled()) {
                            log.debug("Registering samplerCreator {} for content type:{}", (Object)commandClass.getName(), (Object)contentType);
                        }
                        if ((oldSamplerCreator = this.samplerCreatorMap.put(contentType, creator)) == null) continue;
                        log.warn("A sampler creator was already registered for:{}, class:{}, it will be replaced", (Object)contentType, (Object)oldSamplerCreator.getClass());
                    }
                }
                catch (Exception e) {
                    log.error("Exception registering {} with implementation:{}", SamplerCreator.class.getName(), strClassName, e);
                }
            }
        }
        catch (IOException e) {
            log.error("Exception finding implementations of {}", (Object)SamplerCreator.class, (Object)e);
        }
    }

    public SamplerCreator getSamplerCreator(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) {
        SamplerCreator creator = this.samplerCreatorMap.get(request.getContentType());
        if (creator == null) {
            return DEFAULT_SAMPLER_CREATOR;
        }
        return creator;
    }
}

