/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.protocol.http.util.accesslog.Filter;
import org.apache.jmeter.protocol.http.util.accesslog.LogParser;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestCloneable;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.util.JMeterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="displayName")
public class AccessLogSampler
extends HTTPSampler
implements TestBean,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(AccessLogSampler.class);
    private static final long serialVersionUID = 233L;
    public static final String DEFAULT_CLASS = "org.apache.jmeter.protocol.http.util.accesslog.TCLogParser";
    private transient LogParser parser = null;
    private String logFile;
    private String parserClassName;
    private String filterClassName;
    private transient Filter filter;
    private int count = 0;
    private boolean started = false;

    public void setLogFile(String path) {
        this.logFile = path;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setParserClassName(String classname) {
        this.parserClassName = classname;
    }

    public String getParserClassName() {
        return this.parserClassName;
    }

    public SampleResult sampleWithParser() {
        this.initFilter();
        this.instantiateParser();
        SampleResult res = null;
        try {
            if (this.parser == null) {
                throw new JMeterException("No Parser available");
            }
            int thisCount = this.parser.parseAndConfigure(1, this);
            if (thisCount < 0) {
                return this.errorResult(new Error("Problem parsing the log file"), new HTTPSampleResult());
            }
            if (thisCount == 0) {
                CookieManager cm;
                if (this.count == 0 || this.filter == null) {
                    log.info("Stopping current thread");
                    JMeterContextService.getContext().getThread().stop();
                }
                if (this.filter != null) {
                    this.filter.reset();
                }
                if ((cm = this.getCookieManager()) != null) {
                    cm.clear();
                }
                this.count = 0;
                return this.errorResult(new Error("No entries found"), new HTTPSampleResult());
            }
            this.count = thisCount;
            res = this.sample();
            if (res != null) {
                res.setSampleLabel(this.toString());
            }
        }
        catch (Exception e) {
            log.warn("Sampling failure", e);
            return this.errorResult(e, new HTTPSampleResult());
        }
        return res;
    }

    @Override
    public SampleResult sample(Entry e) {
        return this.sampleWithParser();
    }

    public void instantiateParser() {
        if (this.parser == null) {
            try {
                if (StringUtils.isNotBlank(this.getParserClassName())) {
                    if (StringUtils.isNotBlank(this.getLogFile())) {
                        this.parser = Class.forName(this.getParserClassName()).asSubclass(LogParser.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.parser.setSourceFile(this.getLogFile());
                        this.parser.setFilter(this.filter);
                    } else {
                        log.error("No log file specified");
                    }
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                log.error("", e);
            }
        }
    }

    public String getFilterClassName() {
        return this.filterClassName;
    }

    public void setFilterClassName(String filterClassName) {
        this.filterClassName = filterClassName;
    }

    @Override
    public String getDomain() {
        return super.getDomain();
    }

    @Override
    public void setDomain(String domain) {
        super.setDomain(domain);
    }

    public boolean isImageParsing() {
        return super.isImageParser();
    }

    public void setImageParsing(boolean imageParsing) {
        super.setImageParser(imageParsing);
    }

    public String getPortString() {
        return super.getPropertyAsString("HTTPSampler.port");
    }

    public void setPortString(String port) {
        super.setProperty("HTTPSampler.port", port);
    }

    @Override
    public void setProtocol(String value) {
        this.setProperty("HTTPSampler.protocol", value.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getProtocol() {
        String protocol = this.getPropertyAsString("HTTPSampler.protocol");
        if (StringUtils.isEmpty(protocol)) {
            return "http";
        }
        return protocol;
    }

    protected void initFilter() {
        if (this.filter == null && StringUtils.isNotBlank(this.filterClassName)) {
            try {
                this.filter = Class.forName(this.filterClassName).asSubclass(Filter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("Couldn't instantiate filter '{}'", (Object)this.filterClassName, (Object)e);
            }
        }
    }

    @Override
    public Object clone() {
        AccessLogSampler s = (AccessLogSampler)super.clone();
        if (this.started && StringUtils.isNotBlank(this.filterClassName)) {
            try {
                if (TestCloneable.class.isAssignableFrom(Class.forName(this.filterClassName))) {
                    this.initFilter();
                    s.filter = (Filter)((TestCloneable)((Object)this.filter)).clone();
                }
                if (TestCloneable.class.isAssignableFrom(Class.forName(this.parserClassName))) {
                    this.instantiateParser();
                    s.parser = (LogParser)((TestCloneable)((Object)this.parser)).clone();
                    if (this.filter != null) {
                        s.parser.setFilter(s.filter);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Could not clone cloneable filter", e);
            }
        }
        return s;
    }

    @Override
    public void testEnded() {
        if (this.parser != null) {
            this.parser.close();
        }
        this.filter = null;
        this.started = false;
        super.testEnded();
    }

    @Override
    public void testStarted() {
        this.started = true;
        super.testStarted();
    }

    @Override
    public void threadFinished() {
        if (this.parser instanceof ThreadListener) {
            ((ThreadListener)((Object)this.parser)).threadFinished();
        }
        if (this.filter instanceof ThreadListener) {
            ((ThreadListener)((Object)this.filter)).threadFinished();
        }
    }
}

