/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.protocol.http.sampler.AccessLogSampler;
import org.apache.jmeter.protocol.http.util.accesslog.Filter;
import org.apache.jmeter.protocol.http.util.accesslog.LogParser;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.gui.FileEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogSamplerBeanInfo
extends BeanInfoSupport {
    private static final Logger log = LoggerFactory.getLogger(AccessLogSamplerBeanInfo.class);
    private static final List<String> LOG_PARSER_CLASSES = AccessLogSamplerBeanInfo.logParsers();

    private static List<String> logParsers() {
        try {
            return ClassFinder.findClassesThatExtend(JMeterUtils.getSearchPaths(), new Class[]{LogParser.class});
        }
        catch (IOException e) {
            log.warn("Could not find log parsers.", e);
            return Collections.emptyList();
        }
    }

    public AccessLogSamplerBeanInfo() {
        super(AccessLogSampler.class);
        log.debug("Entered access log sampler bean info");
        try {
            this.createPropertyGroup("defaults", new String[]{"protocol", "domain", "portString", "imageParsing"});
            this.createPropertyGroup("plugins", new String[]{"parserClassName", "filterClassName"});
            this.createPropertyGroup("accesslogfile", new String[]{"logFile"});
            PropertyDescriptor p = this.property("parserClassName");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", "org.apache.jmeter.protocol.http.util.accesslog.TCLogParser");
            p.setValue("notOther", Boolean.TRUE);
            p.setValue("notExpression", Boolean.TRUE);
            log.debug("found parsers: {}", (Object)LOG_PARSER_CLASSES);
            p.setValue("tags", LOG_PARSER_CLASSES.toArray(new String[LOG_PARSER_CLASSES.size()]));
            p = this.property("filterClassName");
            p.setValue("notUndefined", Boolean.FALSE);
            p.setValue("default", "");
            p.setValue("notExpression", Boolean.TRUE);
            List<String> classes = ClassFinder.findClassesThatExtend(JMeterUtils.getSearchPaths(), new Class[]{Filter.class}, false);
            p.setValue("tags", classes.toArray(new String[classes.size()]));
            p = this.property("logFile");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", "");
            p.setPropertyEditorClass(FileEditor.class);
            p = this.property("domain");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", "");
            p = this.property("protocol");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", "http");
            p.setValue("defaultNoSave", Boolean.TRUE);
            p = this.property("portString");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", "");
            p = this.property("imageParsing");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", Boolean.FALSE);
            p.setValue("notOther", Boolean.TRUE);
        }
        catch (IOException e) {
            log.warn("couldn't find classes and set up properties", e);
            throw new RuntimeException("Could not find classes with class finder", e);
        }
        log.debug("Got to end of access log sampler bean info init");
    }
}

