/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.PostWriter;
import org.apache.jmeter.protocol.http.sampler.PutWriter;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPJavaImpl
extends HTTPAbstractImpl {
    private static final boolean OBEY_CONTENT_LENGTH = JMeterUtils.getPropDefault("httpsampler.obey_contentlength", false);
    private static final Logger log = LoggerFactory.getLogger(HTTPJavaImpl.class);
    private static final int MAX_CONN_RETRIES = JMeterUtils.getPropDefault("http.java.sampler.retries", 0);
    private static final byte[] NULL_BA;
    private transient PostWriter postOrPutWriter;
    private volatile HttpURLConnection savedConn;

    protected HTTPJavaImpl(HTTPSamplerBase base) {
        super(base);
    }

    protected void setPostHeaders(URLConnection conn) throws IOException {
        this.postOrPutWriter = new PostWriter();
        this.postOrPutWriter.setHeaders(conn, this.testElement);
    }

    private void setPutHeaders(URLConnection conn) throws IOException {
        this.postOrPutWriter = new PutWriter();
        this.postOrPutWriter.setHeaders(conn, this.testElement);
    }

    protected String sendPostData(URLConnection connection) throws IOException {
        return this.postOrPutWriter.sendPostData(connection, this.testElement);
    }

    private String sendPutData(URLConnection connection) throws IOException {
        return this.postOrPutWriter.sendPostData(connection, this.testElement);
    }

    protected HttpURLConnection setupConnection(URL u, String method, HTTPSampleResult res) throws IOException {
        int rto;
        HttpURLConnection conn;
        SSLManager sslmgr = null;
        if ("https".equalsIgnoreCase(u.getProtocol())) {
            try {
                sslmgr = SSLManager.getInstance();
            }
            catch (Exception e) {
                log.warn("Problem creating the SSLManager: ", e);
            }
        }
        String proxyHost = this.getProxyHost();
        int proxyPort = this.getProxyPortInt();
        if (proxyHost.length() > 0 && proxyPort > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            conn = (HttpURLConnection)u.openConnection(proxy);
        } else {
            conn = (HttpURLConnection)u.openConnection();
        }
        conn.setInstanceFollowRedirects(this.getAutoRedirects());
        int cto = this.getConnectTimeout();
        if (cto > 0) {
            conn.setConnectTimeout(cto);
        }
        if ((rto = this.getResponseTimeout()) > 0) {
            conn.setReadTimeout(rto);
        }
        if ("https".equalsIgnoreCase(u.getProtocol())) {
            try {
                if (null != sslmgr) {
                    sslmgr.setContext(conn);
                }
            }
            catch (Exception e) {
                log.warn("Problem setting the SSLManager for the connection: ", e);
            }
        }
        if (this.getUseKeepAlive()) {
            conn.setRequestProperty("Connection", "keep-alive");
        } else {
            conn.setRequestProperty("Connection", "close");
        }
        conn.setRequestMethod(method);
        this.setConnectionHeaders(conn, u, this.getHeaderManager(), this.getCacheManager());
        String cookies = this.setConnectionCookie(conn, u, this.getCookieManager());
        Map<String, String> securityHeaders = this.setConnectionAuthorization(conn, u, this.getAuthManager());
        if (method.equals("POST")) {
            this.setPostHeaders(conn);
        } else if (method.equals("PUT")) {
            this.setPutHeaders(conn);
        }
        if (res != null) {
            res.setRequestHeaders(this.getAllHeadersExceptCookie(conn, securityHeaders));
            if (cookies != null && !cookies.isEmpty()) {
                res.setCookies(cookies);
            } else {
                res.setCookies(this.getOnlyCookieFromHeaders(conn, securityHeaders));
            }
        }
        return conn;
    }

    protected byte[] readResponse(HttpURLConnection conn, SampleResult res) throws IOException {
        BufferedInputStream in;
        long contentLength = conn.getContentLength();
        if (contentLength == 0L && OBEY_CONTENT_LENGTH) {
            log.info("Content-Length: 0, not reading http-body");
            res.setResponseHeaders(this.getResponseHeaders(conn));
            res.latencyEnd();
            return NULL_BA;
        }
        boolean gzipped = "gzip".equals(conn.getContentEncoding());
        CountingInputStream instream = null;
        try {
            instream = new CountingInputStream(conn.getInputStream());
            in = gzipped ? new BufferedInputStream(new GZIPInputStream(instream)) : new BufferedInputStream(instream);
        }
        catch (IOException e) {
            InputStream errorStream;
            if (!(e.getCause() instanceof FileNotFoundException)) {
                log.error("readResponse: {}", (Object)e.toString());
                Throwable cause = e.getCause();
                if (cause != null) {
                    log.error("Cause: {}", (Object)cause.toString());
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                }
            }
            if ((errorStream = conn.getErrorStream()) == null) {
                if (log.isInfoEnabled()) {
                    log.info("Error Response Code: {}, Server sent no Errorpage", (Object)conn.getResponseCode());
                }
                res.setResponseHeaders(this.getResponseHeaders(conn));
                res.latencyEnd();
                return NULL_BA;
            }
            if (log.isInfoEnabled()) {
                log.info("Error Response Code: {}", (Object)conn.getResponseCode());
            }
            in = gzipped ? new BufferedInputStream(new GZIPInputStream(errorStream)) : new BufferedInputStream(errorStream);
        }
        catch (Exception e) {
            log.error("readResponse: {}", (Object)e.toString());
            Throwable cause = e.getCause();
            if (cause != null) {
                log.error("Cause: {}", (Object)cause.toString());
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
            }
            in = new BufferedInputStream(conn.getErrorStream());
        }
        byte[] responseData = this.readResponse(res, in, contentLength);
        if (instream != null) {
            res.setBodySize(instream.getByteCount());
            instream.close();
        }
        return responseData;
    }

    protected String getResponseHeaders(HttpURLConnection conn) {
        String hfk;
        StringBuilder headerBuf = new StringBuilder();
        headerBuf.append(conn.getHeaderField(0));
        headerBuf.append("\n");
        int i = 1;
        while ((hfk = conn.getHeaderFieldKey(i)) != null) {
            headerBuf.append(hfk);
            headerBuf.append(": ");
            headerBuf.append(conn.getHeaderField(i));
            headerBuf.append("\n");
            ++i;
        }
        return headerBuf.toString();
    }

    private String setConnectionCookie(HttpURLConnection conn, URL u, CookieManager cookieManager) {
        String cookieHeader = null;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(u)) != null) {
            conn.setRequestProperty("Cookie", cookieHeader);
        }
        return cookieHeader;
    }

    private void setConnectionHeaders(HttpURLConnection conn, URL u, HeaderManager headerManager, CacheManager cacheManager) {
        CollectionProperty headers;
        Header[] arrayOfHeaders = null;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            int i = 0;
            arrayOfHeaders = new Header[headers.size()];
            for (JMeterProperty jMeterProperty : headers) {
                Header header = (Header)jMeterProperty.getObjectValue();
                String n = header.getName();
                String v = header.getValue();
                arrayOfHeaders[i++] = header;
                conn.addRequestProperty(n, v);
            }
        }
        if (cacheManager != null) {
            cacheManager.setHeaders(conn, arrayOfHeaders, u);
        }
    }

    private String getOnlyCookieFromHeaders(HttpURLConnection conn, Map<String, String> securityHeaders) {
        String cookieHeader = this.getFromConnectionHeaders(conn, securityHeaders, ONLY_COOKIE, false).trim();
        if (!cookieHeader.isEmpty()) {
            return cookieHeader.substring("Cookie:".length()).trim();
        }
        return "";
    }

    private String getAllHeadersExceptCookie(HttpURLConnection conn, Map<String, String> securityHeaders) {
        return this.getFromConnectionHeaders(conn, securityHeaders, ALL_EXCEPT_COOKIE, true);
    }

    private String getFromConnectionHeaders(HttpURLConnection conn, Map<String, String> securityHeaders, Predicate<String> predicate, boolean addSecurityHeaders) {
        StringBuilder hdrs = new StringBuilder(100);
        Map<String, List<String>> requestHeaders = conn.getRequestProperties();
        for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
            String headerKey = entry.getKey();
            if (!predicate.test(headerKey)) continue;
            for (String value : entry.getValue()) {
                hdrs.append(headerKey);
                hdrs.append(": ");
                hdrs.append(value);
                hdrs.append("\n");
            }
        }
        if (addSecurityHeaders) {
            for (Map.Entry<String, Object> entry : securityHeaders.entrySet()) {
                hdrs.append(entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
            }
        }
        return hdrs.toString();
    }

    private Map<String, String> setConnectionAuthorization(HttpURLConnection conn, URL u, AuthManager authManager) {
        Authorization auth;
        if (authManager != null && (auth = authManager.getAuthForURL(u)) != null) {
            String headerValue = auth.toBasicHeader();
            conn.setRequestProperty("Authorization", headerValue);
            return Collections.singletonMap("Authorization", headerValue);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        HttpURLConnection conn = null;
        String urlStr = url.toString();
        if (log.isDebugEnabled()) {
            log.debug("Start : sample {}, method {}, followingRedirect {}, depth {}", urlStr, method, areFollowingRedirect, frameDepth);
        }
        HTTPSampleResult res = new HTTPSampleResult();
        this.configureSampleLabel(res, url);
        res.setURL(url);
        res.setHTTPMethod(method);
        res.sampleStart();
        CacheManager cacheManager = this.getCacheManager();
        if (cacheManager != null && "GET".equalsIgnoreCase(method) && cacheManager.inCache(url, this.getHeaders(this.getHeaderManager()))) {
            return this.updateSampleResultForResourceInCache(res);
        }
        try {
            int retry;
            for (retry = -1; retry < MAX_CONN_RETRIES; ++retry) {
                try {
                    this.savedConn = conn = this.setupConnection(url, method, res);
                    conn.connect();
                    break;
                }
                catch (BindException e) {
                    if (retry >= MAX_CONN_RETRIES) {
                        log.error("Can't connect after {} retries, message: {}", (Object)retry, (Object)e.toString());
                        throw e;
                    }
                    log.debug("Bind exception, try again");
                    if (conn != null) {
                        this.savedConn = null;
                        conn.disconnect();
                    }
                    this.setUseKeepAlive(false);
                    continue;
                }
                catch (IOException e) {
                    log.debug("Connection failed, giving up");
                    throw e;
                }
            }
            if (retry > MAX_CONN_RETRIES) {
                throw new BindException();
            }
            if (method.equals("POST")) {
                String postBody = this.sendPostData(conn);
                res.setQueryString(postBody);
            } else if (method.equals("PUT")) {
                String putBody = this.sendPutData(conn);
                res.setQueryString(putBody);
            }
            byte[] responseData = this.readResponse(conn, res);
            res.sampleEnd();
            res.setResponseData(responseData);
            int errorLevel = conn.getResponseCode();
            String respMsg = conn.getResponseMessage();
            String hdr = conn.getHeaderField(0);
            if (hdr == null) {
                hdr = "(null)";
            }
            if (errorLevel == -1) {
                if (respMsg != null) {
                    try {
                        errorLevel = Integer.parseInt(respMsg.substring(0, 3));
                        log.warn("ResponseCode==-1; parsed {} as {}", (Object)respMsg, (Object)errorLevel);
                    }
                    catch (NumberFormatException e) {
                        log.warn("ResponseCode==-1; could not parse {} hdr: {}", (Object)respMsg, (Object)hdr);
                    }
                } else {
                    respMsg = hdr;
                    log.warn("ResponseCode==-1 & null ResponseMessage. Header(0)= {} ", (Object)hdr);
                }
            }
            if (errorLevel == -1) {
                res.setResponseCode("(null)");
            } else {
                res.setResponseCode(Integer.toString(errorLevel));
            }
            res.setSuccessful(this.isSuccessCode(errorLevel));
            if (respMsg == null) {
                respMsg = hdr;
            }
            res.setResponseMessage(respMsg);
            String ct = conn.getContentType();
            if (ct != null) {
                res.setContentType(ct);
                res.setEncodingAndType(ct);
            }
            String responseHeaders = this.getResponseHeaders(conn);
            res.setResponseHeaders(responseHeaders);
            if (res.isRedirect()) {
                res.setRedirectLocation(conn.getHeaderField("Location"));
            }
            res.setHeadersSize(responseHeaders.replaceAll("\n", "\r\n").length() + 2);
            if (log.isDebugEnabled()) {
                log.debug("Response headersSize={}, bodySize={}, Total={}", res.getHeadersSize(), res.getBodySizeAsLong(), (long)res.getHeadersSize() + res.getBodySizeAsLong());
            }
            if (this.getAutoRedirects()) {
                res.setURL(conn.getURL());
            }
            this.saveConnectionCookies(conn, url, this.getCookieManager());
            if (cacheManager != null) {
                cacheManager.saveDetails(conn, res);
            }
            res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
            log.debug("End : sample");
            HTTPSampleResult hTTPSampleResult = res;
            this.savedConn = null;
            this.disconnect(conn);
            return hTTPSampleResult;
        }
        catch (IOException e) {
            try {
                if (res.getEndTime() == 0L) {
                    res.sampleEnd();
                }
                this.savedConn = null;
                if (conn != null) {
                    conn.disconnect();
                }
                conn = null;
                HTTPSampleResult hTTPSampleResult = this.errorResult(e, res);
                this.savedConn = null;
                this.disconnect(conn);
                return hTTPSampleResult;
            }
            catch (Throwable throwable) {
                this.savedConn = null;
                this.disconnect(conn);
                throw throwable;
            }
        }
    }

    private Header[] getHeaders(HeaderManager headerManager) {
        CollectionProperty headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            ArrayList<Header> allHeaders = new ArrayList<Header>(headers.size());
            for (JMeterProperty jMeterProperty : headers) {
                allHeaders.add((Header)jMeterProperty.getObjectValue());
            }
            return allHeaders.toArray(new Header[allHeaders.size()]);
        }
        return new Header[0];
    }

    protected void disconnect(HttpURLConnection conn) {
        if (conn != null) {
            String connection = conn.getHeaderField("Connection");
            String protocol = conn.getHeaderField(0);
            if (connection == null && (protocol == null || !protocol.startsWith("HTTP/1.1")) || connection != null && connection.equalsIgnoreCase("close")) {
                conn.disconnect();
            }
        }
    }

    private void saveConnectionCookies(HttpURLConnection conn, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            int i = 1;
            while (conn.getHeaderFieldKey(i) != null) {
                if (conn.getHeaderFieldKey(i).equalsIgnoreCase("set-cookie")) {
                    cookieManager.addCookieFromHeader(conn.getHeaderField(i), u);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean interrupt() {
        HttpURLConnection conn = this.savedConn;
        if (conn != null) {
            this.savedConn = null;
            conn.disconnect();
        }
        return conn != null;
    }

    static {
        log.info("Maximum connection retries = {}", (Object)MAX_CONN_RETRIES);
        NULL_BA = new byte[0];
    }
}

