/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPFileImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPHC4Impl;
import org.apache.jmeter.protocol.http.sampler.HTTPJavaImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;

public final class HTTPSamplerFactory {
    public static final String HTTP_SAMPLER_JAVA = "HTTPSampler";
    public static final String HTTP_SAMPLER_APACHE = "HTTPSampler2";
    public static final String IMPL_HTTP_CLIENT4 = "HttpClient4";
    public static final String IMPL_HTTP_CLIENT3_1 = "HttpClient3.1";
    public static final String IMPL_JAVA = "Java";
    public static final String DEFAULT_CLASSNAME = JMeterUtils.getPropDefault("jmeter.httpsampler", "HttpClient4");

    private HTTPSamplerFactory() {
    }

    public static HTTPSamplerBase newInstance() {
        return HTTPSamplerFactory.newInstance(DEFAULT_CLASSNAME);
    }

    public static HTTPSamplerBase newInstance(String alias) {
        if (alias == null || alias.length() == 0) {
            return new HTTPSamplerProxy();
        }
        if (alias.equals(HTTP_SAMPLER_JAVA) || alias.equals(IMPL_JAVA)) {
            return new HTTPSamplerProxy(IMPL_JAVA);
        }
        if (alias.equals(IMPL_HTTP_CLIENT4) || alias.equals(HTTP_SAMPLER_APACHE) || alias.equals(IMPL_HTTP_CLIENT3_1)) {
            return new HTTPSamplerProxy(IMPL_HTTP_CLIENT4);
        }
        throw new IllegalArgumentException("Unknown sampler type: '" + alias + "'");
    }

    public static String[] getImplementations() {
        return new String[]{IMPL_HTTP_CLIENT4, IMPL_JAVA};
    }

    public static HTTPAbstractImpl getImplementation(String impl, HTTPSamplerBase base) {
        if ("file".equals(base.getProtocol())) {
            return new HTTPFileImpl(base);
        }
        if (JOrphanUtils.isBlank(impl)) {
            impl = DEFAULT_CLASSNAME;
        }
        if (IMPL_JAVA.equals(impl) || HTTP_SAMPLER_JAVA.equals(impl)) {
            return new HTTPJavaImpl(base);
        }
        if (IMPL_HTTP_CLIENT4.equals(impl) || IMPL_HTTP_CLIENT3_1.equals(impl)) {
            return new HTTPHC4Impl(base);
        }
        throw new IllegalArgumentException("Unknown implementation type: '" + impl + "'");
    }
}

