/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler.hc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.protocol.HttpContext;
import org.apache.jmeter.util.HttpSSLProtocolSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyLayeredConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LazyLayeredConnectionSocketFactory.class);
    private static final String PROTOCOL_LIST = JMeterUtils.getPropDefault("https.socket.protocols", "");
    private static final String CIPHER_LIST = JMeterUtils.getPropDefault("https.socket.ciphers", "");
    private static final String[] SUPPORTED_PROTOCOL_LIST = PROTOCOL_LIST.isEmpty() ? null : PROTOCOL_LIST.split(" ");
    private static final String[] SUPPORTED_CIPHER_LIST = CIPHER_LIST.isEmpty() ? null : CIPHER_LIST.split(" ");

    @Override
    public Socket createSocket(HttpContext paramHttpContext) throws IOException {
        return AdapteeHolder.getINSTANCE().createSocket(paramHttpContext);
    }

    @Override
    public Socket connectSocket(int paramInt, Socket paramSocket, HttpHost paramHttpHost, InetSocketAddress paramInetSocketAddress1, InetSocketAddress paramInetSocketAddress2, HttpContext paramHttpContext) throws IOException {
        return AdapteeHolder.getINSTANCE().connectSocket(paramInt, paramSocket, paramHttpHost, paramInetSocketAddress1, paramInetSocketAddress2, paramHttpContext);
    }

    @Override
    public Socket createLayeredSocket(Socket paramSocket, String paramString, int paramInt, HttpContext paramHttpContext) throws IOException {
        return AdapteeHolder.getINSTANCE().createLayeredSocket(paramSocket, paramString, paramInt, paramHttpContext);
    }

    private static class AdapteeHolder {
        private static final LayeredConnectionSocketFactory ADAPTEE = AdapteeHolder.checkAndInit();

        private AdapteeHolder() {
        }

        private static LayeredConnectionSocketFactory checkAndInit() throws SSLInitializationException {
            LOG.info("Setting up HTTPS TrustAll Socket Factory");
            return new SSLConnectionSocketFactory((SSLSocketFactory)new HttpSSLProtocolSocketFactory(JsseSSLManager.CPS), SUPPORTED_PROTOCOL_LIST, SUPPORTED_CIPHER_LIST, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }

        static LayeredConnectionSocketFactory getINSTANCE() {
            return ADAPTEE;
        }
    }
}

