/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util.accesslog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.accesslog.Generator;
import org.apache.jmeter.protocol.http.util.accesslog.NVPair;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardGenerator
implements Generator,
Serializable {
    private static final long serialVersionUID = 234L;
    private static final Logger log = LoggerFactory.getLogger(StandardGenerator.class);
    protected HTTPSamplerBase SAMPLE = null;
    protected transient OutputStream OUTPUT = null;
    protected String FILENAME = null;
    protected File FILE = null;

    public StandardGenerator() {
        this.init();
    }

    public StandardGenerator(String file) {
        this.FILENAME = file;
        this.init();
    }

    private void init() {
        this.generateRequest();
    }

    protected void initStream() {
        try {
            this.OUTPUT = new FileOutputStream(this.FILE);
        }
        catch (IOException exception) {
            log.error(exception.getMessage());
        }
    }

    @Override
    public void close() {
        JOrphanUtils.closeQuietly(this.OUTPUT);
    }

    @Override
    public void setHost(String host) {
        this.SAMPLE.setDomain(host);
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public void setMethod(String post_get) {
        this.SAMPLE.setMethod(post_get);
    }

    @Override
    public void setParams(NVPair[] params) {
        for (NVPair param : params) {
            this.SAMPLE.addArgument(param.getName(), param.getValue());
        }
    }

    @Override
    public void setPath(String path) {
        this.SAMPLE.setPath(path);
    }

    @Override
    public void setPort(int port) {
        this.SAMPLE.setPort(port);
    }

    @Override
    public void setQueryString(String querystring) {
        this.SAMPLE.parseArguments(querystring);
    }

    @Override
    public void setSourceLogs(String sourcefile) {
    }

    @Override
    public void setTarget(Object target) {
    }

    @Override
    public Object generateRequest() {
        this.SAMPLE = HTTPSamplerFactory.newInstance();
        return this.SAMPLE;
    }

    @Override
    public void save() {
    }

    @Override
    public void reset() {
        this.SAMPLE = null;
        this.generateRequest();
    }
}

