/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.util.BSFTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSFSampler
extends BSFTestElement
implements Sampler,
TestBean,
ConfigMergabilityIndicator {
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(BSFSampler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleResult sample(Entry e) {
        String label = this.getName();
        String request = this.getScript();
        String fileName = this.getFilename();
        log.debug("{} {}", (Object)label, (Object)fileName);
        SampleResult res = new SampleResult();
        res.setSampleLabel(label);
        BSFEngine bsfEngine = null;
        BSFManager mgr = new BSFManager();
        res.setResponseCode("200");
        res.setResponseMessage("OK");
        res.setSuccessful(true);
        res.setDataType("text");
        res.sampleStart();
        try {
            Object bsfOut;
            block33: {
                this.initManager(mgr);
                mgr.declareBean("SampleResult", (Object)res, res.getClass());
                bsfEngine = mgr.loadScriptingEngine(this.getScriptLanguage());
                bsfOut = null;
                if (fileName.length() > 0) {
                    res.setSamplerData("File: " + fileName);
                    try (FileInputStream fis = new FileInputStream(fileName);
                         BufferedInputStream is = new BufferedInputStream(fis);){
                        bsfOut = bsfEngine.eval(fileName, 0, 0, (Object)IOUtils.toString((InputStream)is, Charset.defaultCharset()));
                        break block33;
                    }
                }
                res.setSamplerData(request);
                bsfOut = bsfEngine.eval("script", 0, 0, (Object)request);
            }
            if (bsfOut != null) {
                res.setResponseData(bsfOut.toString(), null);
            }
        }
        catch (BSFException ex) {
            log.warn("BSF error", ex);
            res.setSuccessful(false);
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
        }
        catch (Exception ex) {
            log.warn("Problem evaluating the script", ex);
            res.setSuccessful(false);
            res.setResponseCode("500");
            res.setResponseMessage(ex.toString());
        }
        finally {
            res.sampleEnd();
            mgr.terminate();
        }
        return res;
    }

    @Override
    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

