/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSampler
extends AbstractSampler
implements TestStateListener,
Interruptible {
    private static final Logger log = LoggerFactory.getLogger(JavaSampler.class);
    private static final long serialVersionUID = 233L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.protocol.java.config.gui.JavaConfigGui", "org.apache.jmeter.config.gui.SimpleConfigGui"));
    private static final Set<JavaSampler> TEAR_DOWN_SET = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final String CLASSNAME = "classname";
    public static final String ARGUMENTS = "arguments";
    private Class<?> javaClass;
    private boolean isToBeRegistered;
    private transient JavaSamplerClient javaClient = null;
    private transient JavaSamplerContext context = null;

    public JavaSampler() {
        this.setArguments(new Arguments());
    }

    @Override
    public Object clone() {
        JavaSampler clone = (JavaSampler)super.clone();
        clone.javaClass = this.javaClass;
        clone.isToBeRegistered = this.isToBeRegistered;
        return clone;
    }

    private void initClass() {
        String name = this.getClassname().trim();
        try {
            this.javaClass = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            Method method = this.javaClass.getMethod("teardownTest", JavaSamplerContext.class);
            this.isToBeRegistered = !method.getDeclaringClass().equals(AbstractJavaSamplerClient.class);
            log.info("Created class: {}. Uses tearDownTest: ", (Object)name, (Object)this.isToBeRegistered);
        }
        catch (Exception e) {
            log.error("{}\tException initialising: ", this.whoAmI(), name, e);
        }
    }

    public void setArguments(Arguments args) {
        this.setProperty(new TestElementProperty(ARGUMENTS, args));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname);
    }

    public String getClassname() {
        return this.getPropertyAsString(CLASSNAME);
    }

    @Override
    public SampleResult sample(Entry entry) {
        SampleResult result;
        Arguments args = this.getArguments();
        args.addArgument("TestElement.name", this.getName());
        this.context = new JavaSamplerContext(args);
        if (this.javaClient == null) {
            if (log.isDebugEnabled()) {
                log.debug("{}\tCreating Java Client", (Object)this.whoAmI());
            }
            this.javaClient = this.createJavaClient();
            this.javaClient.setupTest(this.context);
        }
        if ((result = this.javaClient.runTest(this.context)) != null && result.getSampleLabel().length() == 0) {
            result.setSampleLabel(this.getName());
        }
        return result;
    }

    private JavaSamplerClient createJavaClient() {
        JavaSamplerClient client;
        if (this.javaClass == null) {
            return new ErrorSamplerClient();
        }
        try {
            client = (JavaSamplerClient)this.javaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug("{}\tCreated:\t{}@{}", this.whoAmI(), this.getClassname(), Integer.toHexString(client.hashCode()));
            }
            if (this.isToBeRegistered) {
                TEAR_DOWN_SET.add(this);
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("{}\tException creating: {}", this.whoAmI(), this.getClassname(), e);
            }
            client = new ErrorSamplerClient();
        }
        return client;
    }

    private String whoAmI() {
        return Thread.currentThread().getName() + "@" + Integer.toHexString(this.hashCode()) + "-" + this.getName();
    }

    @Override
    public void testStarted() {
        if (log.isDebugEnabled()) {
            log.debug("{}\ttestStarted", (Object)this.whoAmI());
        }
        this.initClass();
    }

    @Override
    public void testStarted(String host) {
        if (log.isDebugEnabled()) {
            log.debug("{}\ttestStarted({})", (Object)this.whoAmI(), (Object)host);
        }
        this.initClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEnded() {
        if (log.isDebugEnabled()) {
            log.debug("{}\ttestEnded", (Object)this.whoAmI());
        }
        Set<JavaSampler> set = TEAR_DOWN_SET;
        synchronized (set) {
            for (JavaSampler javaSampler : TEAR_DOWN_SET) {
                JavaSamplerClient client = javaSampler.javaClient;
                if (client == null) continue;
                client.teardownTest(javaSampler.context);
            }
            TEAR_DOWN_SET.clear();
        }
    }

    @Override
    public void testEnded(String host) {
        this.testEnded();
    }

    @Override
    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    @Override
    public boolean interrupt() {
        if (this.javaClient instanceof Interruptible) {
            return ((Interruptible)((Object)this.javaClient)).interrupt();
        }
        return false;
    }

    class ErrorSamplerClient
    extends AbstractJavaSamplerClient {
        ErrorSamplerClient() {
        }

        @Override
        public SampleResult runTest(JavaSamplerContext p_context) {
            if (log.isDebugEnabled()) {
                log.debug("{}\trunTest", (Object)JavaSampler.this.whoAmI());
            }
            Thread.yield();
            SampleResult results = new SampleResult();
            results.setSuccessful(false);
            results.setResponseData("Class not found: " + JavaSampler.this.getClassname(), null);
            results.setSampleLabel("ERROR: " + JavaSampler.this.getClassname());
            return results;
        }
    }
}

