/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleWriter;
import org.apache.jmeter.save.SaveService;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSampleWriter
extends SampleWriter {
    private static final int BUF_SIZE = 10000;
    private static final String CHARSET = SaveService.getFileEncoding(StandardCharsets.UTF_8.displayName());
    private static Logger log = LoggerFactory.getLogger(AbstractSampleWriter.class);
    protected PrintWriter writer;

    public void setWriter(Writer newWriter) {
        Validate.notNull(newWriter, "writer must not be null.", new Object[0]);
        if (this.writer != null) {
            JOrphanUtils.closeQuietly(this.writer);
        }
        this.writer = new PrintWriter((Writer)new BufferedWriter(newWriter, 10000), false);
    }

    public void setOutputStream(OutputStream out) {
        Validate.notNull(out, "out must not be null.", new Object[0]);
        try {
            this.setWriter(new OutputStreamWriter(out, CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Unsupported CHARSET: {}", (Object)CHARSET, (Object)e);
        }
    }

    public void setOutputFile(File output) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
        }
        catch (Exception e) {
            throw new SampleException(e.getMessage(), e);
        }
        this.setOutputStream(fos);
    }

    @Override
    public void close() {
        JOrphanUtils.closeQuietly(this.writer);
        this.writer = null;
    }

    void flush() {
        this.writer.flush();
    }
}

