/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.samplers.SampleSaveConfiguration;

public class SampleMetadata {
    List<String> columns;
    private TreeMap<String, Integer> index = new TreeMap();
    private char separator;

    public SampleMetadata(char separator, String ... columns) {
        Validate.notNull(columns, "columns must not be null", new Object[0]);
        this.initialize(separator, Arrays.asList(columns));
    }

    public SampleMetadata(SampleSaveConfiguration saveConfig) {
        ArrayList<String> configuredColumns = new ArrayList<String>();
        if (saveConfig.saveTimestamp()) {
            configuredColumns.add("timeStamp");
        }
        if (saveConfig.saveTime()) {
            configuredColumns.add("elapsed");
        }
        if (saveConfig.saveLabel()) {
            configuredColumns.add("label");
        }
        if (saveConfig.saveCode()) {
            configuredColumns.add("responseCode");
        }
        if (saveConfig.saveMessage()) {
            configuredColumns.add("responseMessage");
        }
        if (saveConfig.saveThreadName()) {
            configuredColumns.add("threadName");
        }
        if (saveConfig.saveDataType()) {
            configuredColumns.add("dataType");
        }
        if (saveConfig.saveSuccess()) {
            configuredColumns.add("success");
        }
        if (saveConfig.saveAssertionResultsFailureMessage()) {
            configuredColumns.add("failureMessage");
        }
        if (saveConfig.saveBytes()) {
            configuredColumns.add("bytes");
        }
        if (saveConfig.saveSentBytes()) {
            configuredColumns.add("sentBytes");
        }
        if (saveConfig.saveThreadCounts()) {
            configuredColumns.add("grpThreads");
            configuredColumns.add("allThreads");
        }
        if (saveConfig.saveUrl()) {
            configuredColumns.add("URL");
        }
        if (saveConfig.saveFileName()) {
            configuredColumns.add("Filename");
        }
        if (saveConfig.saveLatency()) {
            configuredColumns.add("Latency");
        }
        if (saveConfig.saveEncoding()) {
            configuredColumns.add("Encoding");
        }
        if (saveConfig.saveSampleCount()) {
            configuredColumns.add("SampleCount");
            configuredColumns.add("ErrorCount");
        }
        if (saveConfig.saveHostname()) {
            configuredColumns.add("Hostname");
        }
        if (saveConfig.saveIdleTime()) {
            configuredColumns.add("IdleTime");
        }
        if (saveConfig.saveConnectTime()) {
            configuredColumns.add("Connect");
        }
        this.initialize(saveConfig.getDelimiter().charAt(0), configuredColumns);
    }

    private void initialize(char separator, List<String> columns) {
        this.separator = separator;
        this.columns = columns;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            this.index.put(this.columns.get(i).trim(), i);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int i) {
        return this.columns.get(i);
    }

    public String getColumnName(Integer i) {
        return this.columns.get(i);
    }

    public int indexOf(String col) {
        Integer out = this.index.get(col);
        return out == null ? -1 : out;
    }

    public int ensureIndexOf(String col) {
        int index = this.indexOf(col);
        if (index < 0) {
            throw new SampleException(String.format("No column <%s> found in sample metadata <%s>, check #jmeter.save.saveservice.* properties to add the missing column", col, this.toString()));
        }
        return index;
    }

    public String toString() {
        return StringUtils.join(this.columns, this.separator);
    }
}

