/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.config.SubConfiguration;
import org.apache.jmeter.report.dashboard.DataExporter;
import org.apache.jmeter.report.dashboard.ExportException;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ResultData;
import org.apache.jmeter.report.processor.ValueResultData;

public abstract class AbstractDataExporter
implements DataExporter {
    private String name;

    protected AbstractDataExporter() {
    }

    protected static <T> T findValue(Class<T> clazz, String data, ResultData root) {
        ValueResultData valueResult;
        Object object;
        T value = null;
        ResultData result = AbstractDataExporter.findData(data, root);
        if (result instanceof ValueResultData && (object = (valueResult = (ValueResultData)result).getValue()) != null && clazz.isAssignableFrom(object.getClass())) {
            value = clazz.cast(object);
        }
        return value;
    }

    protected static ResultData findData(String data, ResultData root) {
        String[] pathItems = StringUtils.split(data, '.');
        if (pathItems == null || !(root instanceof MapResultData)) {
            return null;
        }
        ResultData result = null;
        int count = pathItems.length;
        int index = 0;
        MapResultData map = (MapResultData)root;
        while (index < count && result == null) {
            ResultData current = map.getResult(pathItems[index]);
            if (index == count - 1) {
                result = current;
                continue;
            }
            if (!(current instanceof MapResultData)) continue;
            map = (MapResultData)current;
            ++index;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    protected <T> T getPropertyFromConfig(SubConfiguration cfg, String property, T defaultValue, Class<T> clazz) throws ExportException {
        try {
            return cfg.getProperty(property, defaultValue, clazz);
        }
        catch (ConfigurationException ex) {
            throw new ExportException(String.format("Wrong property \"%s\" in \"%s\" export configuration", property, this.getName()), ex);
        }
    }
}

