/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.report.config.ExporterConfiguration;
import org.apache.jmeter.report.config.GraphConfiguration;
import org.apache.jmeter.report.config.ReportGeneratorConfiguration;
import org.apache.jmeter.report.config.SubConfiguration;
import org.apache.jmeter.report.core.DataContext;
import org.apache.jmeter.report.core.TimeHelper;
import org.apache.jmeter.report.dashboard.AbstractDataExporter;
import org.apache.jmeter.report.dashboard.ExportException;
import org.apache.jmeter.report.dashboard.JsonizerVisitor;
import org.apache.jmeter.report.dashboard.TemplateVisitor;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ResultData;
import org.apache.jmeter.report.processor.ResultDataVisitor;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTemplateExporter
extends AbstractDataExporter {
    private static final String CUSTOM_GRAPH_PREFIX = "custom_";
    private static final String MUST_NOT_BE_NULL = "%s must not be null";
    private static final Logger log = LoggerFactory.getLogger(HtmlTemplateExporter.class);
    public static final String DATA_CTX_REPORT_TITLE = "reportTitle";
    public static final String DATA_CTX_TESTFILE = "testFile";
    public static final String DATA_CTX_BEGINDATE = "beginDate";
    public static final String DATA_CTX_ENDDATE = "endDate";
    public static final String DATA_CTX_TIMEZONE = "timeZone";
    public static final String DATA_CTX_TIMEZONE_OFFSET = "timeZoneOffset";
    public static final String DATA_CTX_OVERALL_FILTER = "overallFilter";
    public static final String DATA_CTX_SHOW_CONTROLLERS_ONLY = "showControllersOnly";
    public static final String DATA_CTX_RESULT = "result";
    public static final String DATA_CTX_EXTRA_OPTIONS = "extraOptions";
    public static final String DATA_CTX_SERIES_FILTER = "seriesFilter";
    public static final String DATA_CTX_FILTERS_ONLY_SAMPLE_SERIES = "filtersOnlySampleSeries";
    public static final String TIMESTAMP_FORMAT_MS = "ms";
    private static final String TEMPLATE_DIR = "template_dir";
    private static final String TEMPLATE_DIR_NAME_DEFAULT = "report-template";
    static final String OUTPUT_DIR = "output_dir";
    static final String OUTPUT_DIR_NAME_DEFAULT = "report-output";

    private void addToContext(String key, Object value, DataContext context) {
        if (value instanceof String) {
            value = '\"' + (String)value + '\"';
        }
        context.put(key, value);
    }

    private boolean htmlReportFileFilter(File file) {
        String fileName = file.getName();
        boolean isIndexHtmlFile = file.isFile() && fileName.equals("index.html");
        boolean isContentOrAdmin = fileName.equals("content") || fileName.startsWith("sbadmin2-");
        return isIndexHtmlFile || file.isDirectory() && isContentOrAdmin;
    }

    @Override
    public void export(SampleContext context, File file, ReportGeneratorConfiguration configuration) throws ExportException {
        Validate.notNull(context, MUST_NOT_BE_NULL, "context");
        Validate.notNull(file, MUST_NOT_BE_NULL, "file");
        Validate.notNull(configuration, MUST_NOT_BE_NULL, "configuration");
        log.debug("Start template processing");
        DataContext dataContext = new DataContext();
        ExporterConfiguration exportCfg = configuration.getExportConfigurations().get(this.getName());
        File templateDirectory = this.getPropertyFromConfig(exportCfg, TEMPLATE_DIR, new File(JMeterUtils.getJMeterBinDir(), TEMPLATE_DIR_NAME_DEFAULT), File.class);
        if (!templateDirectory.isDirectory()) {
            String message = String.format("\"%s\" is not a valid template directory", templateDirectory.getAbsolutePath());
            log.error(message);
            throw new ExportException(message);
        }
        File outputDir = this.getPropertyFromConfig(exportCfg, OUTPUT_DIR, new File(JMeterUtils.getJMeterBinDir(), OUTPUT_DIR_NAME_DEFAULT), File.class);
        String globallyDefinedOutputDir = JMeterUtils.getProperty("jmeter.reportgenerator.outputdir");
        if (!StringUtils.isEmpty(globallyDefinedOutputDir)) {
            outputDir = new File(globallyDefinedOutputDir);
        }
        JOrphanUtils.canSafelyWriteToFolder(outputDir, this::htmlReportFileFilter);
        if (log.isInfoEnabled()) {
            log.info("Will generate dashboard in folder: {}", (Object)outputDir.getAbsolutePath());
        }
        boolean filtersOnlySampleSeries = exportCfg.filtersOnlySampleSeries();
        this.addToContext(DATA_CTX_FILTERS_ONLY_SAMPLE_SERIES, filtersOnlySampleSeries, dataContext);
        String seriesFilter = exportCfg.getSeriesFilter();
        Pattern filterPattern = null;
        if (StringUtils.isNotBlank(seriesFilter)) {
            try {
                filterPattern = Pattern.compile(seriesFilter);
            }
            catch (PatternSyntaxException ex) {
                log.error("Invalid series filter: '{}', {}", (Object)seriesFilter, (Object)ex.getDescription());
            }
        }
        this.addToContext(DATA_CTX_SERIES_FILTER, seriesFilter, dataContext);
        boolean showControllerSeriesOnly = exportCfg.showControllerSeriesOnly();
        this.addToContext(DATA_CTX_SHOW_CONTROLLERS_ONLY, showControllerSeriesOnly, dataContext);
        JsonizerVisitor jsonizer = new JsonizerVisitor();
        Map<String, Object> storedData = context.getData();
        this.addResultToContext(DATA_CTX_BEGINDATE, storedData, dataContext, jsonizer);
        this.addResultToContext(DATA_CTX_ENDDATE, storedData, dataContext, jsonizer);
        this.addResultToContext("apdexSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("errorsSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("requestsSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("statisticsSummary", storedData, dataContext, jsonizer);
        this.addResultToContext("top5ErrorsBySampler", storedData, dataContext, jsonizer);
        ExtraOptionsResultCustomizer customizer = new ExtraOptionsResultCustomizer();
        EmptyGraphChecker checker = new EmptyGraphChecker(filtersOnlySampleSeries, showControllerSeriesOnly, filterPattern);
        HashMap<String, GraphConfiguration> mapConfiguration = new HashMap<String, GraphConfiguration>();
        DataContext customGraphs = new DataContext();
        for (Map.Entry<String, GraphConfiguration> graphEntry : configuration.getGraphConfigurations().entrySet()) {
            String graphId = graphEntry.getKey();
            GraphConfiguration graphConfiguration = graphEntry.getValue();
            customizer.setExtraOptions(exportCfg.getGraphExtraConfigurations().get(graphId));
            checker.setExcludesControllers(graphConfiguration.excludesControllers());
            checker.setGraphId(graphId);
            mapConfiguration.put(graphId, graphConfiguration);
            if (graphId.startsWith(CUSTOM_GRAPH_PREFIX)) {
                this.addResultToContext(graphId, storedData, customGraphs, jsonizer, customizer, checker);
                continue;
            }
            this.addResultToContext(graphId, storedData, dataContext, jsonizer, customizer, checker);
        }
        dataContext.put("graphConfigurations", mapConfiguration);
        dataContext.put("customsGraphsData", customGraphs);
        long oldTimestamp = this.formatTimestamp(DATA_CTX_BEGINDATE, dataContext);
        this.formatTimestamp(DATA_CTX_ENDDATE, dataContext);
        TimeZone timezone = TimeZone.getDefault();
        this.addToContext(DATA_CTX_TIMEZONE_OFFSET, timezone.getOffset(oldTimestamp), dataContext);
        if (StringUtils.isNotEmpty(configuration.getReportTitle())) {
            dataContext.put(DATA_CTX_REPORT_TITLE, StringEscapeUtils.escapeHtml4(configuration.getReportTitle()));
        }
        this.addToContext(DATA_CTX_TESTFILE, file.getName(), dataContext);
        this.addToContext(DATA_CTX_OVERALL_FILTER, configuration.getSampleFilter(), dataContext);
        Configuration templateCfg = new Configuration(Configuration.VERSION_2_3_30);
        try {
            templateCfg.setDirectoryForTemplateLoading(templateDirectory);
            templateCfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            if (log.isInfoEnabled()) {
                log.info("Report will be generated in: {}, creating folder structure", (Object)outputDir.getAbsolutePath());
            }
            FileUtils.forceMkdir(outputDir);
            TemplateVisitor visitor = new TemplateVisitor(templateDirectory.toPath(), outputDir.toPath(), templateCfg, dataContext);
            Files.walkFileTree(templateDirectory.toPath(), visitor);
        }
        catch (IOException ex) {
            throw new ExportException("Unable to process template files.", ex);
        }
        log.debug("End of template processing");
    }

    private <T> void addResultToContext(String resultKey, Map<String, Object> storage, DataContext dataContext, ResultDataVisitor<T> visitor) {
        this.addResultToContext(resultKey, storage, dataContext, visitor, null, null);
    }

    private <T> void addResultToContext(String resultKey, Map<String, Object> storage, DataContext dataContext, ResultDataVisitor<T> visitor, ResultCustomizer customizer, ResultChecker checker) {
        Object data = storage.get(resultKey);
        if (data instanceof ResultData) {
            ResultData result = (ResultData)data;
            if (checker != null) {
                checker.checkResult(dataContext, result);
            }
            if (customizer != null) {
                result = customizer.customizeResult(result);
            }
            dataContext.put(resultKey, result.accept(visitor));
        }
    }

    private long formatTimestamp(String key, DataContext context) {
        double result = Double.parseDouble((String)context.get(key));
        long timestamp = (long)result;
        context.put(key, '\"' + TimeHelper.formatTimeStamp(timestamp) + '\"');
        return timestamp;
    }

    private static class EmptyGraphChecker
    implements ResultChecker {
        private final boolean filtersOnlySampleSeries;
        private final boolean showControllerSeriesOnly;
        private final Pattern filterPattern;
        private boolean excludesControllers;
        private String graphId;

        public final void setExcludesControllers(boolean excludesControllers) {
            this.excludesControllers = excludesControllers;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        public EmptyGraphChecker(boolean filtersOnlySampleSeries, boolean showControllerSeriesOnly, Pattern filterPattern) {
            this.filtersOnlySampleSeries = filtersOnlySampleSeries;
            this.showControllerSeriesOnly = showControllerSeriesOnly;
            this.filterPattern = filterPattern;
        }

        @Override
        public boolean checkResult(DataContext dataContext, ResultData result) {
            boolean supportsControllerDiscrimination = AbstractDataExporter.findValue(Boolean.class, "supportsControllersDiscrimination", result);
            if (supportsControllerDiscrimination && this.showControllerSeriesOnly && this.excludesControllers) {
                log.warn("{} is set while the graph {} excludes controllers.", (Object)"show_controllers_only", (Object)this.graphId);
                return false;
            }
            if (this.filterPattern == null) {
                return true;
            }
            ResultData seriesResult = AbstractDataExporter.findData("series", result);
            if (!(seriesResult instanceof ListResultData)) {
                return true;
            }
            ListResultData seriesList = (ListResultData)seriesResult;
            int count = seriesList.getSize();
            boolean matches = false;
            for (int index = 0; index < count && !matches; ++index) {
                ResultData currentResult = seriesList.get(index);
                if (!(currentResult instanceof MapResultData)) continue;
                MapResultData seriesData = (MapResultData)currentResult;
                String name = AbstractDataExporter.findValue(String.class, "label", seriesData);
                boolean isController = AbstractDataExporter.findValue(Boolean.class, "isController", seriesData);
                matches = this.filterPattern.matcher(name).matches();
                if (matches) {
                    boolean bl = matches = !this.filtersOnlySampleSeries || !supportsControllerDiscrimination || isController || !this.showControllerSeriesOnly;
                    if (!log.isDebugEnabled()) continue;
                    log.debug("name:{} matches pattern:{}, supportsControllerDiscrimination:{}, isController:{}, showControllerSeriesOnly:{}", name, this.filterPattern.pattern(), supportsControllerDiscrimination, isController, this.showControllerSeriesOnly);
                    continue;
                }
                boolean bl = matches = this.filtersOnlySampleSeries && !supportsControllerDiscrimination;
                if (!log.isDebugEnabled()) continue;
                log.debug("name:{} does not match pattern:{}, filtersOnlySampleSeries:{}, supportsControllerDiscrimination:{}", name, this.filterPattern.pattern(), this.filtersOnlySampleSeries, supportsControllerDiscrimination);
            }
            if (!matches) {
                log.warn("No series matches the series_filter: {} in graph: {}", (Object)"series_filter", (Object)this.graphId);
                return false;
            }
            return true;
        }
    }

    private static interface ResultChecker {
        public boolean checkResult(DataContext var1, ResultData var2);
    }

    private static class ExtraOptionsResultCustomizer
    implements ResultCustomizer {
        private SubConfiguration extraOptions;

        private ExtraOptionsResultCustomizer() {
        }

        public final void setExtraOptions(SubConfiguration extraOptions) {
            this.extraOptions = extraOptions;
        }

        @Override
        public ResultData customizeResult(ResultData result) {
            MapResultData customizedResult = new MapResultData();
            customizedResult.setResult(HtmlTemplateExporter.DATA_CTX_RESULT, result);
            if (this.extraOptions == null) {
                return customizedResult;
            }
            MapResultData extraResult = new MapResultData();
            this.extraOptions.getProperties().forEach((key, value) -> extraResult.setResult((String)key, new ValueResultData(value)));
            customizedResult.setResult(HtmlTemplateExporter.DATA_CTX_EXTRA_OPTIONS, extraResult);
            return customizedResult;
        }
    }

    private static interface ResultCustomizer {
        public ResultData customizeResult(ResultData var1);
    }
}

