/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.config.ExporterConfiguration;
import org.apache.jmeter.report.config.ReportGeneratorConfiguration;
import org.apache.jmeter.report.dashboard.AbstractDataExporter;
import org.apache.jmeter.report.dashboard.ExportException;
import org.apache.jmeter.report.dashboard.SamplingStatistic;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonExporter
extends AbstractDataExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonExporter.class);
    public static final String OUTPUT_FILENAME = "statistics.json";
    private static final FileFilter JSON_FILE_FILTER = file -> file.isFile() && file.getName().equals(OUTPUT_FILENAME);
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();

    @Override
    public void export(SampleContext context, File file, ReportGeneratorConfiguration reportGeneratorConfiguration) throws ExportException {
        Object data = context.getData().get("statisticsSummary");
        if (data instanceof MapResultData) {
            LOGGER.info("Found data for consumer {}\u00a0in context", (Object)"statisticsSummary");
            MapResultData result = (MapResultData)data;
            HashMap<String, SamplingStatistic> statistics = new HashMap<String, SamplingStatistic>();
            MapResultData overallData = (MapResultData)result.getResult("overall");
            LOGGER.info("Creating statistics for overall");
            this.createStatistic(statistics, overallData);
            ListResultData itemsData = (ListResultData)result.getResult("items");
            LOGGER.info("Creating statistics for other transactions");
            itemsData.forEach(r -> this.createStatistic(statistics, (MapResultData)r));
            LOGGER.info("Checking output folder");
            File outputDir = this.checkAndGetOutputFolder(reportGeneratorConfiguration);
            File outputFile = new File(outputDir, OUTPUT_FILENAME);
            LOGGER.info("Writing statistics JSON to {}", (Object)outputFile);
            try (BufferedWriter fileWriter = Files.newBufferedWriter(outputFile.toPath(), new OpenOption[0]);){
                OBJECT_WRITER.writeValue((Writer)fileWriter, statistics);
            }
            catch (IOException e) {
                throw new ExportException("Error generating JSON statistics file to " + outputFile + " for " + statistics, e);
            }
        }
    }

    private File checkAndGetOutputFolder(ReportGeneratorConfiguration reportGeneratorConfiguration) throws ExportException {
        ExporterConfiguration exportCfg = reportGeneratorConfiguration.getExportConfigurations().get(this.getName());
        File outputDir = this.getPropertyFromConfig(exportCfg, "output_dir", new File(JMeterUtils.getJMeterBinDir(), "report-output"), File.class);
        String globallyDefinedOutputDir = JMeterUtils.getProperty("jmeter.reportgenerator.outputdir");
        if (!StringUtils.isEmpty(globallyDefinedOutputDir)) {
            outputDir = new File(globallyDefinedOutputDir);
        }
        JOrphanUtils.canSafelyWriteToFolder(outputDir, JSON_FILE_FILTER);
        try {
            FileUtils.forceMkdir(outputDir);
        }
        catch (IOException ex) {
            throw new ExportException("Error creating output folder " + outputDir.getAbsolutePath(), ex);
        }
        return outputDir;
    }

    private void createStatistic(Map<String, SamplingStatistic> statistics, MapResultData resultData) {
        LOGGER.debug("Creating statistics for result data:{}", (Object)resultData);
        SamplingStatistic statistic = new SamplingStatistic();
        ListResultData listResultData = (ListResultData)resultData.getResult("data");
        statistic.setTransaction((String)((ValueResultData)listResultData.get(0)).getValue());
        statistic.setSampleCount((Long)((ValueResultData)listResultData.get(1)).getValue());
        statistic.setErrorCount((Long)((ValueResultData)listResultData.get(2)).getValue());
        statistic.setErrorPct(((Double)((ValueResultData)listResultData.get(3)).getValue()).floatValue());
        statistic.setMeanResTime((Double)((ValueResultData)listResultData.get(4)).getValue());
        statistic.setMinResTime(((Long)((ValueResultData)listResultData.get(5)).getValue()).longValue());
        statistic.setMaxResTime(((Long)((ValueResultData)listResultData.get(6)).getValue()).longValue());
        statistic.setMedianResTime((Double)((ValueResultData)listResultData.get(7)).getValue());
        statistic.setPct1ResTime((Double)((ValueResultData)listResultData.get(8)).getValue());
        statistic.setPct2ResTime((Double)((ValueResultData)listResultData.get(9)).getValue());
        statistic.setPct3ResTime((Double)((ValueResultData)listResultData.get(10)).getValue());
        statistic.setThroughput((Double)((ValueResultData)listResultData.get(11)).getValue());
        statistic.setReceivedKBytesPerSec((Double)((ValueResultData)listResultData.get(12)).getValue());
        statistic.setSentKBytesPerSec((Double)((ValueResultData)listResultData.get(13)).getValue());
        statistics.put(statistic.getTransaction(), statistic);
    }
}

