/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.CsvFile;
import org.apache.jmeter.report.core.CsvSampleReader;
import org.apache.jmeter.report.core.CsvSampleWriter;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleComparator;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.Job;
import org.apache.jmeter.report.processor.SampleProducer;
import org.apache.jmeter.report.processor.SampleWriterConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSampleSorter
extends AbstractSampleConsumer {
    private static final String MUST_NOT_BE_NULL = "%s must not be null";
    private static final Logger LOG = LoggerFactory.getLogger(ExternalSampleSorter.class);
    private static final int DEFAULT_CHUNK_SIZE = 50000;
    private long chunkSize = 50000L;
    private SampleComparator sampleComparator;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor pool;
    private volatile int nbProcessors;
    private boolean parallelize;
    private final AtomicLong chunkedSampleCount = new AtomicLong();
    private final AtomicLong inputSampleCount = new AtomicLong();
    private List<File> chunks;
    private List<Sample> samples;
    private SampleMetadata sampleMetadata;
    private boolean revertedSort;
    private final AtomicInteger sequence = new AtomicInteger();

    public ExternalSampleSorter() {
        this.nbProcessors = Runtime.getRuntime().availableProcessors();
        this.parallelize = this.nbProcessors > 1;
        this.pool = new ThreadPoolExecutor(this.nbProcessors, this.nbProcessors + 5, 10L, TimeUnit.SECONDS, this.workQueue);
        this.setRevertedSort(false);
    }

    public ExternalSampleSorter(SampleComparator comparator) {
        this();
        this.setSampleComparator(comparator);
    }

    public void setChunkSize(long chunkSize) {
        if (chunkSize < 50000L) {
            chunkSize = 50000L;
        }
        this.chunkSize = chunkSize;
    }

    public final void setSampleComparator(SampleComparator sampleComparator) {
        this.sampleComparator = sampleComparator;
    }

    public void setParallelize(boolean parallelize) {
        this.parallelize = parallelize;
    }

    public boolean isParallelize() {
        return this.parallelize;
    }

    public void sort(CsvFile inputFile, File outputFile, boolean writeHeader) {
        if (!inputFile.isFile()) {
            throw new SampleException(inputFile.getAbsolutePath() + " does not exist or is not a file. Please provide an existing samples file");
        }
        if (outputFile.isDirectory()) {
            throw new SampleException(outputFile.getAbsolutePath() + " is a directory. Please provide a valid output sample file path (not a directory)");
        }
        try (CsvSampleReader csvReader = new CsvSampleReader(inputFile, inputFile.getSeparator(), false);){
            this.sort(csvReader, outputFile, writeHeader);
        }
    }

    public void sort(SampleMetadata sampleMetadata, File inputFile, File outputFile, boolean writeHeader) {
        Validate.notNull(sampleMetadata, MUST_NOT_BE_NULL, "sampleMetadata");
        if (!inputFile.isFile()) {
            throw new SampleException(inputFile.getAbsolutePath() + " does not exist or is not a file. Please provide an existing samples file");
        }
        if (outputFile.isDirectory()) {
            throw new SampleException(outputFile.getAbsolutePath() + " is a directory. Please provide a valid output sample file path (not a directory)");
        }
        try (CsvSampleReader csvReader = new CsvSampleReader(inputFile, sampleMetadata);){
            this.sort(csvReader, outputFile, writeHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sort(CsvSampleReader csvReader, File output, boolean writeHeader) {
        Validate.notNull(output, MUST_NOT_BE_NULL, "output");
        SampleMetadata readSampleMetadata = csvReader.getMetadata();
        SampleWriterConsumer writerConsumer = new SampleWriterConsumer();
        writerConsumer.setOutputFile(output);
        writerConsumer.setWriteHeader(writeHeader);
        this.addSampleConsumer(writerConsumer);
        try {
            super.setConsumedMetadata(readSampleMetadata, 0);
            this.startConsuming();
            Sample s = null;
            while ((s = csvReader.readSample()) != null) {
                this.consume(s, 0);
            }
            this.stopConsuming();
        }
        finally {
            this.removeSampleConsumer(writerConsumer);
        }
    }

    @Override
    public void startConsuming() {
        Validate.validState(this.sampleComparator != null, "sampleComparator is not set, call setSampleComparator() first.", new Object[0]);
        File workDir = this.getWorkingDirectory();
        workDir.mkdir();
        this.pool.prestartAllCoreThreads();
        this.inputSampleCount.set(0L);
        this.chunkedSampleCount.set(0L);
        this.chunks = new ArrayList<File>();
        this.samples = new ArrayList<Sample>();
        this.sampleMetadata = this.getConsumedMetadata(0);
        this.sampleComparator.initialize(this.sampleMetadata);
    }

    @Override
    public void consume(Sample s, int channel) {
        this.samples.add(s);
        this.inputSampleCount.incrementAndGet();
        if ((long)this.samples.size() >= this.chunkSize) {
            this.chunks.add(this.sortAndDump(this.samples, this.sampleMetadata));
            this.samples.clear();
        }
    }

    @Override
    public void stopConsuming() {
        if (!this.samples.isEmpty()) {
            this.chunks.add(this.sortAndDump(this.samples, this.sampleMetadata));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sort(): " + this.inputSampleCount.longValue() + " samples read from input, " + this.chunkedSampleCount.longValue() + " samples written to chunk files");
            if (this.inputSampleCount.get() != this.chunkedSampleCount.get()) {
                LOG.error("Failure! Number of samples read from input and written to chunk files differ");
            } else {
                LOG.info("dumping of samples chunk succeeded.");
            }
        }
        super.setProducedMetadata(this.sampleMetadata, 0);
        super.startProducing();
        this.sortFilesParallel(this.chunks, this.sampleMetadata, this);
        super.stopProducing();
        if (this.pool != null) {
            this.pool.shutdown();
        }
        if (!this.getWorkingDirectory().delete()) {
            LOG.warn("Was not able to delete folder {}", (Object)this.getWorkingDirectory());
        }
    }

    private File sortAndDump(List<Sample> samples, SampleMetadata sampleMetadata) {
        List<Sample> sortedSamples;
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("sortAndDump(): Sorting " + samples.size() + " samples...");
            start = System.currentTimeMillis();
        }
        if ((sortedSamples = this.sortSamplesParallel(samples)).size() != samples.size()) {
            throw new SampleException("sort failed ! " + sortedSamples.size() + " != " + samples.size());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sortAndDump(): in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " s. Sorted  " + samples.size() + " samples.");
        }
        File out = this.getChunkFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sortAndDump(): Dumping chunk " + out);
            start = System.currentTimeMillis();
        }
        try (CsvSampleWriter csvWriter = new CsvSampleWriter(out, sampleMetadata);){
            for (Sample sample : sortedSamples) {
                csvWriter.write(sample);
                this.chunkedSampleCount.incrementAndGet();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sortAndDump(): in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " s : Dumped chunk " + out.getAbsolutePath());
        }
        return out;
    }

    private List<Sample> sortSamplesParallel(List<Sample> samples) {
        List<Sample> newRight;
        List<Sample> newLeft;
        int sz = samples.size();
        if (sz <= 1) {
            return samples;
        }
        int middle = sz / 2;
        List<Sample> left = samples.subList(0, middle);
        List<Sample> right = samples.subList(middle, sz);
        Job<List<Sample>> jobLeft = this.createSortJob(left);
        Job<List<Sample>> jobRight = this.createSortJob(right);
        if (this.parallelize) {
            this.workQueue.add(jobLeft);
            this.workQueue.add(jobRight);
            try {
                newLeft = jobLeft.getResult();
                newRight = jobRight.getResult();
            }
            catch (InterruptedException ie) {
                throw new SampleException("Unexpected interruption !", ie);
            }
        } else {
            newLeft = jobLeft.exec();
            newRight = jobRight.exec();
        }
        return this.merge(newLeft, newRight);
    }

    private Job<List<Sample>> createSortJob(final List<Sample> samples) {
        return new Job<List<Sample>>(){

            @Override
            protected List<Sample> exec() {
                return ExternalSampleSorter.this.sort(samples);
            }
        };
    }

    public List<Sample> sort(List<Sample> samples) {
        int sz = samples.size();
        if (sz <= 1) {
            return samples;
        }
        int middle = sz / 2;
        List<Sample> left = samples.subList(0, middle);
        List<Sample> right = samples.subList(middle, sz);
        left = this.sort(left);
        right = this.sort(right);
        return this.merge(left, right);
    }

    private List<Sample> merge(List<Sample> left, List<Sample> right) {
        ArrayList<Sample> out = new ArrayList<Sample>();
        ListIterator<Sample> l = left.listIterator();
        ListIterator<Sample> r = right.listIterator();
        while (l.hasNext() || r.hasNext()) {
            if (l.hasNext() && r.hasNext()) {
                Sample firstLeft = l.next();
                Sample firstRight = r.next();
                if (!this.revertedSort && this.sampleComparator.compare(firstLeft, firstRight) < 0L || this.revertedSort && this.sampleComparator.compare(firstLeft, firstRight) >= 0L) {
                    out.add(firstLeft);
                    r.previous();
                    continue;
                }
                out.add(firstRight);
                l.previous();
                continue;
            }
            if (l.hasNext()) {
                out.add(l.next());
                continue;
            }
            if (!r.hasNext()) continue;
            out.add(r.next());
        }
        return out;
    }

    public void mergeFiles(List<File> chunks, SampleMetadata metadata, SampleProducer producer) {
        this.sortFilesParallel(chunks, metadata, producer);
    }

    private void sortFilesParallel(List<File> chunks, SampleMetadata metadata, SampleProducer out) {
        int sz = chunks.size();
        if (sz > 1) {
            File rightFile;
            File leftFile;
            int middle = sz / 2;
            List<File> left = chunks.subList(0, middle);
            List<File> right = chunks.subList(middle, sz);
            Job<File> leftJob = this.createMergeJob(left, metadata);
            Job<File> rightJob = this.createMergeJob(right, metadata);
            if (this.parallelize) {
                this.workQueue.add(leftJob);
                this.workQueue.add(rightJob);
                try {
                    leftFile = leftJob.getResult();
                    rightFile = rightJob.getResult();
                }
                catch (InterruptedException ie) {
                    throw new SampleException("Unexpected interruption !", ie);
                }
            } else {
                leftFile = leftJob.exec();
                rightFile = rightJob.exec();
            }
            this.mergeFiles(metadata, leftFile, rightFile, out);
        } else {
            File f = chunks.get(0);
            try (CsvSampleReader reader = new CsvSampleReader(f, metadata);){
                Sample sample;
                while ((sample = reader.readSample()) != null) {
                    out.produce(sample, 0);
                }
            }
        }
    }

    private Job<File> createMergeJob(final List<File> chunks, final SampleMetadata metadata) {
        return new Job<File>(){

            @Override
            protected File exec() {
                return ExternalSampleSorter.this.mergeSortFiles(chunks, metadata);
            }
        };
    }

    private File mergeSortFiles(List<File> chunks, SampleMetadata metadata) {
        int sz = chunks.size();
        if (sz == 1) {
            return chunks.get(0);
        }
        int middle = sz / 2;
        List<File> left = chunks.subList(0, middle);
        List<File> right = chunks.subList(middle, sz);
        File leftFile = this.mergeSortFiles(left, metadata);
        File rightFile = this.mergeSortFiles(right, metadata);
        return this.mergeFiles(leftFile, rightFile, metadata);
    }

    private File mergeFiles(File left, File right, SampleMetadata metadata) {
        File out = this.getChunkFile();
        this.mergeFiles(metadata, left, right, out, false);
        return out;
    }

    private void mergeFiles(SampleMetadata metadata, File left, File right, File out, boolean writeHeader) {
        if (out == null) {
            out = this.getChunkFile();
        }
        try (CsvSampleWriter csvWriter = new CsvSampleWriter(out, metadata);
             CsvSampleReader l = new CsvSampleReader(left, metadata);
             CsvSampleReader r = new CsvSampleReader(right, metadata);){
            if (writeHeader) {
                csvWriter.writeHeader();
            }
            while (l.hasNext() || r.hasNext()) {
                if (l.hasNext() && r.hasNext()) {
                    Sample firstRight;
                    Sample firstLeft = l.peek();
                    if (this.leftBeforeRight(firstLeft, firstRight = r.peek())) {
                        csvWriter.write(firstLeft);
                        l.readSample();
                        continue;
                    }
                    csvWriter.write(firstRight);
                    r.readSample();
                    continue;
                }
                if (l.hasNext()) {
                    csvWriter.write(l.readSample());
                    continue;
                }
                if (!r.hasNext()) continue;
                csvWriter.write(r.readSample());
            }
        }
    }

    private void mergeFiles(SampleMetadata metadata, File left, File right, SampleProducer out) {
        try (CsvSampleReader l = new CsvSampleReader(left, metadata);
             CsvSampleReader r = new CsvSampleReader(right, metadata);){
            while (l.hasNext() || r.hasNext()) {
                if (l.hasNext() && r.hasNext()) {
                    Sample firstRight;
                    Sample firstLeft = l.peek();
                    if (this.leftBeforeRight(firstLeft, firstRight = r.peek())) {
                        out.produce(firstLeft, 0);
                        l.readSample();
                        continue;
                    }
                    out.produce(firstRight, 0);
                    r.readSample();
                    continue;
                }
                if (l.hasNext()) {
                    out.produce(l.readSample(), 0);
                    continue;
                }
                if (!r.hasNext()) continue;
                out.produce(r.readSample(), 0);
            }
        }
    }

    private boolean leftBeforeRight(Sample leftSample, Sample rightSample) {
        return !this.revertedSort && this.sampleComparator.compare(leftSample, rightSample) < 0L || this.revertedSort && this.sampleComparator.compare(leftSample, rightSample) >= 0L;
    }

    private File getChunkFile() {
        DecimalFormat df = new DecimalFormat("00000");
        File out = new File(this.getWorkingDirectory(), "chunk-" + df.format(this.sequence.incrementAndGet()) + ".csv");
        out.deleteOnExit();
        return out;
    }

    public final boolean isRevertedSort() {
        return this.revertedSort;
    }

    public final void setRevertedSort(boolean revertedSort) {
        this.revertedSort = revertedSort;
    }
}

