/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.core.ConvertException;
import org.apache.jmeter.report.core.Converters;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.MeanAggregatorFactory;
import org.apache.jmeter.report.processor.SampleConsumer;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.GraphValueSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;

public class CustomGraphConsumer
extends AbstractOverTimeGraphConsumer
implements SampleConsumer {
    public static final String RESULT_Y_AXIS = "Y_Axis";
    public static final String RESULT_X_AXIS = "X_Axis";
    public static final String RESULT_SAMPLE_VARIABLE_NAME = "sample_Metric_Name";
    public static final String RESULT_CONTENT_MESSAGE = "content_Message";
    public static final String REPORT_GENERATOR_PROPERTIES = "jmeter.reportgenerator.graph.customGraph.property";
    private static final Set<String> NATIVE_VARIABLES = new HashSet<String>(Arrays.asList("dataType", "failureMessage", "label", "responseCode", "responseMessage", "success", "threadName", "timeStamp", "elapsed", "bytes", "sentBytes", "grpThreads", "allThreads", "SampleCount", "ErrorCount", "URL", "Filename", "Latency", "Connect", "Encoding", "Hostname", "IdleTime"));
    private String yAxis;
    private String xAxis;
    private String contentMessage;
    private String sampleVariableName;
    private boolean isNativeSampleVariableName = false;

    public boolean getIsNativeSampleVariableName() {
        return this.isNativeSampleVariableName;
    }

    public String getYAxis() {
        return this.yAxis;
    }

    public String getXAxis() {
        return this.xAxis;
    }

    public void setYAxis(String axis) {
        this.yAxis = axis;
    }

    public void setXAxis(String axis) {
        this.xAxis = axis;
    }

    public void setContentMessage(String message) {
        this.contentMessage = message;
    }

    public String getContentMessage() {
        return this.contentMessage;
    }

    public String getSampleVariableName() {
        return this.sampleVariableName;
    }

    public void setSampleVariableName(String sampleVarName) {
        this.sampleVariableName = sampleVarName;
        this.isNativeSampleVariableName = NATIVE_VARIABLES.contains(sampleVarName);
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        parentResult.setResult("granularity", new ValueResultData(this.getGranularity()));
        parentResult.setResult(RESULT_Y_AXIS, new ValueResultData(this.getYAxis()));
        parentResult.setResult(RESULT_X_AXIS, new ValueResultData(this.getXAxis()));
        parentResult.setResult(RESULT_SAMPLE_VARIABLE_NAME, new ValueResultData(this.getSampleVariableName()));
        parentResult.setResult(RESULT_CONTENT_MESSAGE, new ValueResultData(this.getContentMessage()));
    }

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        AbstractSeriesSelector seriesSelector = new AbstractSeriesSelector(){

            @Override
            public Iterable<String> select(Sample sample) {
                return Collections.singletonList(CustomGraphConsumer.this.sampleVariableName);
            }
        };
        GraphValueSelector graphValueSelector = (series, sample) -> {
            String value = this.isNativeSampleVariableName ? sample.getData(this.sampleVariableName) : sample.getData("\"" + this.sampleVariableName + "\"");
            if (StringUtils.isEmpty(value) || "null".equals(value)) {
                return null;
            }
            try {
                return Converters.convert(Double.class, value);
            }
            catch (ConvertException e) {
                throw new IllegalArgumentException("Double converter failed", e);
            }
        };
        return Collections.singletonMap("Generic group", new GroupInfo(new MeanAggregatorFactory(), seriesSelector, graphValueSelector, false, false));
    }
}

